package me.rufia.fightorflight.goals.targeting;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1400;

public class PokemonTauntedTargetGoal extends class_1400<PokemonEntity> {
    protected PokemonEntity pokemonEntity;
    protected PokemonEntity targetPokemon;
    protected float safeDistanceSqr = (float) Math.pow(CobblemonFightOrFlight.moveConfig().status_move_radius, 2);

    public PokemonTauntedTargetGoal(PokemonEntity entity, boolean mustSee) {
        super(entity, PokemonEntity.class, 10, mustSee, false, (livingEntity) -> {
            if (livingEntity instanceof PokemonEntity pokemon) {
                return pokemon.method_35057() != null;
            }
            return false;
        });
        pokemonEntity = entity;
    }

    public boolean isTaunted() {
        if (field_6644 instanceof PokemonEntity pokemonEntity1) {
            if (pokemonEntity1.method_35057() != null && PokemonUtils.canTaunt(pokemonEntity1)) {
                targetPokemon = pokemonEntity1;
                return PokemonUtils.WildPokemonCanPerformUnprovokedAttack(pokemonEntity);
            }
        }
        targetPokemon = null;
        return false;
    }

    public boolean method_6264() {
        if (!CobblemonFightOrFlight.moveConfig().wild_pokemon_taunt || pokemonEntity.method_35057() != null) {
            return false;
        }
        if (super.method_6264()) {
            if (isTaunted()) {
                field_6644 = targetPokemon;
                return true;
            } else {
                field_6644 = null;
            }
        }
        return false;
    }
}
