package me.rufia.fightorflight.mixin;

import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.effects.FOFEffects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {

    @Shadow
    @Nullable
    public abstract class_1293 getEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract boolean hasEffect(class_6880<class_1291> effect);

    @ModifyVariable(method = "hurt", at = @At("HEAD"), argsOnly = true)
    private float updateDmg(float damageAmount) {
        if (hasEffect(FOFEffects.RESISTANCE_WEAKENED)) {
            int amp = -1;
            var effect = getEffect(FOFEffects.RESISTANCE_WEAKENED);
            if (effect != null) {
                //CobblemonFightOrFlight.LOGGER.info("EFFECT DETECTED! Amp:{}", effect.getAmplifier());
                amp = effect.method_5578();
            }
            if (amp > 3) {
                amp = 3;
            }
            return damageAmount * 5 / (4 - amp);
        }
        return damageAmount;
    }
}
