package me.rufia.fightorflight.net.handler;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import dev.architectury.networking.NetworkManager;
import me.rufia.fightorflight.item.ItemFightOrFlight;
import me.rufia.fightorflight.net.NetworkPacketHandler;
import me.rufia.fightorflight.net.packet.PokeStaffCmdPacket;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public abstract class PokeStaffCmdHandler<T extends PokeStaffCmdPacket> implements NetworkPacketHandler<T> {
    protected class_1799 getStack(class_1657 player) {
        if (player.method_6047().method_31574(ItemFightOrFlight.POKESTAFF.get())) {
            return player.method_6047();
        } else if (player.method_6079().method_31574(ItemFightOrFlight.POKESTAFF.get())) {
            return player.method_6079();
        } else {
            return null;
        }
    }

    protected void handlePacket(T packet, NetworkManager.PacketContext context) {
        class_1657 player = context.getPlayer();
        int slot = packet.getSlot();
        if (player instanceof class_3222 serverPlayer) {
            Pokemon pokemon = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer).get(slot);
            if (pokemon != null) {
                PokemonState state = pokemon.getState();
                if (state instanceof ShoulderedState || !(state instanceof ActivePokemonState activePokemonState)) {
                    //nothing to do
                } else {
                    PokemonEntity pokemonEntity = activePokemonState.getEntity();
                    processCommand(pokemonEntity, player, packet);
                }
            }
        }
    }

    protected void processCommand(PokemonEntity pokemonEntity, class_1657 player, T packet) {
        if (pokemonEntity != null) {
            class_1799 stack = getStack(player);
            if (stack == null) {
                if (PokemonUtils.shouldCheckPokeStaff()) {
                    return;
                }
            } else {
                editStaff(stack, packet);
            }
            finalProcess(pokemonEntity, player, packet);
        }
    }

    protected abstract void editStaff(class_1799 stack, T packet);

    protected abstract void finalProcess(PokemonEntity pokemonEntity, class_1657 player, T packet);
}
