package me.rufia.fightorflight.net.handler;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.architectury.networking.NetworkManager;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.item.PokeStaff;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.packet.SendMoveSlotPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import java.util.Objects;

public class SendMoveSlotHandler extends PokeStaffCmdHandler<SendMoveSlotPacket> {
    private int moveSlot;

    @Override
    public void handle(SendMoveSlotPacket packet, NetworkManager.PacketContext context) {
        moveSlot = packet.getMoveSlot();
        handlePacket(packet, context);
    }

    @Override
    protected void editStaff(class_1799 stack, SendMoveSlotPacket packet) {
        PokeStaff staff = (PokeStaff) stack.method_7909();
        if (!packet.isFromPokeStaff()) {
            staff.setMoveSlot(stack, moveSlot);
            staff.setCommandMode(stack, PokeStaffComponent.CMDMODE.NOCMD.name());
            staff.setMode(stack, PokeStaffComponent.MODE.SEND.name());
        }
    }

    @Override
    protected void finalProcess(PokemonEntity pokemonEntity, class_1657 player, SendMoveSlotPacket packet) {
        Move move = pokemonEntity.getPokemon().getMoveSet().get(moveSlot);
        String oldMoveName = ((PokemonInterface) pokemonEntity).getCurrentMove();
        if (move != null) {
            if (Objects.equals(move.getName(), oldMoveName)) {
                ((PokemonInterface) pokemonEntity).tryUsingStatusMoves();
            } else {
                if (PokemonAttackEffect.canChangeMove(pokemonEntity)) {
                    ((PokemonInterface) pokemonEntity).switchMove(move);
                    player.method_43496(class_2561.method_43469("item.fightorflight.pokestaff.move", pokemonEntity.getPokemon().getDisplayName(false), move.getDisplayName()));
                } else {
                    player.method_43496(class_2561.method_43469("item.fightorflight.pokestaff.move.failed", pokemonEntity.getPokemon().getDisplayName(false)));
                }
            }
        }
    }
}
