package me.rufia.fightorflight.utils.explosion;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class FOFExplosion extends class_1927 {
    protected static final class_5362 EXPLOSION_DAMAGE_CALCULATOR = new class_5362();
    protected final boolean fire;
    protected final class_1927.class_4179 blockInteraction;
    protected final class_5819 random;
    protected final class_1937 level;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final PokemonEntity pokemon;
    protected final boolean shouldHurtAlly;
    @Nullable
    public class_1297 field_9185;
    public float field_9190;
    protected final class_1282 damageSource;
    protected final class_5362 damageCalculator;
    protected final ObjectArrayList<class_2338> toBlow;
    protected final Map<class_1657, class_243> hitPlayers;

    public FOFExplosion(class_1937 level, @Nullable class_1297 source, PokemonEntity pokemon, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, class_1927.class_4179 blockInteraction, boolean shouldHurtAlly, boolean isProjectileExplosion) {
        super(level, source, damageSource, damageCalculator, toBlowX, toBlowY, toBlowZ, radius, fire, blockInteraction, null, null, class_3417.field_15152);
        this.random = class_5819.method_43047();
        this.toBlow = new ObjectArrayList<>();
        this.hitPlayers = Maps.newHashMap();
        this.level = level;
        this.field_9185 = source;
        this.field_9190 = radius + pokemonExplosionBaseValue(isProjectileExplosion);
        this.x = toBlowX;
        this.y = toBlowY;
        this.z = toBlowZ;
        this.fire = fire;
        this.blockInteraction = blockInteraction;
        this.damageSource = damageSource == null ? level.method_48963().method_48830() : damageSource;
        this.damageCalculator = damageCalculator == null ? this.method_29553(source) : damageCalculator;
        this.pokemon = pokemon;
        this.shouldHurtAlly = shouldHurtAlly;
    }

    protected class_5362 method_29553(@Nullable class_1297 entity) {
        return (entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new class_5361(entity));
    }

    public static Optional<Float> getBlockExplosionResistance(class_2680 state, class_3610 fluid) {
        return state.method_26215() && fluid.method_15769() ? Optional.empty() : Optional.of(Math.max(state.method_26204().method_9520(), fluid.method_15760()));
    }

    public void method_8348() {
        this.level.method_43275(this.field_9185, class_5712.field_28178, new class_243(this.x, this.y, this.z));
        Set<class_2338> set = Sets.newHashSet();

        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j == 0 || j == 15 || k == 0 || k == 15 || l == 0 || l == 15) {
                        double d = (float) j / 15.0F * 2.0F - 1.0F;
                        double e = (float) k / 15.0F * 2.0F - 1.0F;
                        double f = (float) l / 15.0F * 2.0F - 1.0F;
                        double g = Math.sqrt(d * d + e * e + f * f);
                        d /= g;
                        e /= g;
                        f /= g;
                        float h = this.field_9190 * (0.8F + this.level.field_9229.method_43057() * 0.2F);
                        double m = this.x;
                        double n = this.y;
                        double o = this.z;

                        for (float p = 0.3F; h > 0.0F; h -= 0.22500001F) {
                            class_2338 blockPos = class_2338.method_49637(m, n, o);
                            class_2680 blockState = this.level.method_8320(blockPos);
                            class_3610 fluidState = this.level.method_8316(blockPos);
                            if (!this.level.method_24794(blockPos)) {
                                break;
                            }

                            Optional<Float> optional = getBlockExplosionResistance(blockState, fluidState);
                            if (optional.isPresent()) {
                                h -= (optional.get() + 0.3F) * 0.3F;
                                //CobblemonFightOrFlight.LOGGER.info(Float.toString(h));
                            }

                            if (h > 0.0F) {
                                set.add(blockPos);
                            }

                            m += d * 0.3;
                            n += e * 0.3;
                            o += f * 0.3;
                        }
                    }
                }
            }
        }

        this.toBlow.addAll(set);
        PokemonAttackEffect.dealAoEDamage(pokemon, field_9185, shouldHurtAlly, false);
    }

    @Override
    public void method_8350(boolean spawnParticles) {
        finalizeExplosion();
    }

    public void finalizeExplosion() {
        if (this.level.field_9236) {
            this.level.method_8486(this.x, this.y, this.z, class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0F, (1.0F + (this.level.field_9229.method_43057() - this.level.field_9229.method_43057()) * 0.2F) * 0.7F, false);
        } else {
            this.level.method_60511(null, x, y, z, class_3417.field_15152, class_3419.field_15245, 4.0F, (1.0F + (this.level.field_9229.method_43057() - this.level.field_9229.method_43057()) * 0.2F) * 0.7F);
        }
        //CobblemonFightOrFlight.LOGGER.info("Explosion finalizing");
        boolean bl = this.method_46667();

        class_2394 particleType;
        if (!(this.field_9190 < 2.0F)) {
            particleType = class_2398.field_11221;
        } else {
            particleType = class_2398.field_11236;
        }

        if (this.level instanceof class_3218 serverLevel) {
            serverLevel.method_14199(particleType, this.x, this.y, this.z, 1, 1.0, 0.0, 0.0, 1.0f);
        }
        //replace it with type-specific particle

        if (bl) {
            List<Pair<class_1799, class_2338>> list = new ArrayList<>();
            class_156.method_43028(this.toBlow, this.level.field_9229);

            for (class_2338 blockPos : this.toBlow) {
                this.level.method_8320(blockPos).method_55225(this.level, blockPos, this, (itemStack, blockPosx) -> {
                    method_24023(list, itemStack, blockPosx);
                });
            }

            for (Pair<class_1799, class_2338> pair : list) {
                net.minecraft.class_2248.method_9577(this.level, pair.getSecond(), pair.getFirst());
            }

            this.level.method_16107().method_15407();

            for (Pair<class_1799, class_2338> pair : list) {
                net.minecraft.class_2248.method_9577(this.level, pair.getSecond(), pair.getFirst());
            }
        }

        if (this.fire) {
            for (class_2338 blockPos3 : this.toBlow) {
                if (this.random.method_43048(3) == 0 && this.level.method_8320(blockPos3).method_26215() && this.level.method_8320(blockPos3.method_10074()).method_26216(this.level, blockPos3.method_10074())) {
                    this.level.method_8501(blockPos3, class_4770.method_24416(this.level, blockPos3));
                }
            }
        }
    }

    public boolean method_46667() {
        return this.blockInteraction != class_1927.class_4179.field_40878;
    }

    public static FOFExplosion createExplosion(class_1297 source, PokemonEntity pokemonEntity, double x, double y, double z, boolean shouldHurtAlly, boolean isProjectileExplosion) {
        if (pokemonEntity == null) {
            CobblemonFightOrFlight.LOGGER.warn("trying to create a new FOFExplosion without PokemonEntity");
            return null;
        }
        float radius = calculateRadius(pokemonEntity);
        ElementalType type1 = pokemonEntity.getPokemon().getPrimaryType();
        ElementalType type2 = pokemonEntity.getPokemon().getSecondaryType();
        boolean shouldCreateFire = CobblemonFightOrFlight.moveConfig().should_create_fire && (type1.equals(ElementalTypes.INSTANCE.getFIRE()) || (type2 != null && type2.equals(ElementalTypes.INSTANCE.getFIRE())));
        class_4179 blockInteraction1;
        if (CobblemonFightOrFlight.moveConfig().pokemon_griefing) {
            blockInteraction1 = class_4179.field_40879;
            //CobblemonFightOrFlight.LOGGER.info("will destroy blocks");
        } else {
            blockInteraction1 = class_4179.field_40878;
        }
        return new FOFExplosion(source.method_37908(), source, pokemonEntity, source.method_48923().method_48819(pokemonEntity, pokemonEntity), null, x, y, z, radius, shouldCreateFire, blockInteraction1, shouldHurtAlly, isProjectileExplosion);
    }

    protected static float calculateRadius(PokemonEntity pokemonEntity) {
        Move move = PokemonUtils.shouldShoot(pokemonEntity) ? PokemonUtils.getRangeAttackMove(pokemonEntity) : PokemonUtils.getMeleeMove(pokemonEntity);
        if (move == null) {
            return 0.0f;
        }
        return PokemonAttackEffect.getAoERadius(pokemonEntity, move);
    }

    protected float pokemonExplosionBaseValue(boolean isProjectileExplosion) {
        return (isProjectileExplosion ? 0.0f : 5.0f);
    }

    protected static void method_24023(List<Pair<class_1799, class_2338>> drops, class_1799 stack, class_2338 pos) {
        for (int i = 0; i < drops.size(); ++i) {
            Pair<class_1799, class_2338> pair = drops.get(i);
            class_1799 itemStack = pair.getFirst();
            if (class_1542.method_24017(itemStack, stack)) {
                drops.set(i, Pair.of(class_1542.method_24018(itemStack, stack, 16), (class_2338) pair.getSecond()));
                if (stack.method_7960()) {
                    return;
                }
            }
        }

        drops.add(Pair.of(stack, pos));
    }
}
