package me.rufia.fightorflight.utils.listeners;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.behavior.PokemonBehaviorData;
import me.rufia.fightorflight.data.behavior.PokemonBehaviorDataContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

public class BehaviorDataListener extends class_4080<Map<class_2960, PokemonBehaviorDataContainer>> {
    public BehaviorDataListener() {
    }

    @Override
    protected Map<class_2960, PokemonBehaviorDataContainer> method_18789(class_3300 resourceManager, class_3695 profiler) {
        Map<class_2960, PokemonBehaviorDataContainer> map = new HashMap<>();
        CobblemonFightOrFlight.LOGGER.info("[FOF] Preparing to read behavior data");
        prepareTag(resourceManager, "normal", PokemonBehaviorDataContainer.class, map);

        return map;
    }

    //TODO read the file
    private void prepareTag(class_3300 resourceManager, String tagName, Type type, Map<class_2960, PokemonBehaviorDataContainer> map) {
        for (var entry : resourceManager.method_14488("fof_behavior_data/" + tagName, fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            var resourceLocation = entry.getKey();
            var resource = entry.getValue();
            try {
                JsonReader reader = new JsonReader(new InputStreamReader(resource.method_14482()));
                Gson gson = new Gson();
                map.put(resourceLocation, gson.fromJson(reader, type));
            } catch (Exception e) {
                CobblemonFightOrFlight.LOGGER.warn("Failed to read {}", resourceLocation);
            }
        }
    }

    private void register(Map<String, ? extends PokemonBehaviorData> dataMap) {
        for (var mapEntry : dataMap.entrySet()) {
            if (!(PokemonBehaviorData.behaviorData.containsKey(mapEntry.getKey()) && PokemonBehaviorData.behaviorData.get(mapEntry.getKey()) != null)) {
                PokemonBehaviorData.behaviorData.put(mapEntry.getKey(), new ArrayList<>());
            }
            PokemonBehaviorData.behaviorData.get(mapEntry.getKey()).add(mapEntry.getValue());
        }
    }

    @Override
    protected void apply(Map<class_2960, PokemonBehaviorDataContainer> map, class_3300 resourceManager, class_3695 profiler) {
        int fileCount = 0;
        for (var entry : map.entrySet()) {
            var location = entry.getKey();
            var container = entry.getValue();
            Map<String, PokemonBehaviorData> dataMap = container.build();
            if (dataMap != null) {
                register(dataMap);
                ++fileCount;
            }
        }
        CobblemonFightOrFlight.LOGGER.info("[FOF] {} behavior data files processed.", fileCount);
    }
}
