/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter;

import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.registry.MLDataAttachmentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="mixed_litter")
public class Events {
    @SubscribeEvent
    public static void onEntitySpawned(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        if (!entity.level().isClientSide) {
            entity.setData(MLDataAttachmentTypes.SPAWN_LOCATION, (Object)GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)entity.blockPosition()));
            VariantUtil.applySuitableVariants((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onEntityLoaded(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VariantUtil.validateVariants(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onBabyEntitySpawned(BabyEntitySpawnEvent event) {
        AgeableMob child = event.getChild();
        if (child != null && !child.level().isClientSide) {
            VariantUtil.setChildVariant((Entity)event.getParentA(), (Entity)event.getParentB(), (Entity)child);
        }
    }

    @SubscribeEvent
    public static void updateVariant(EntityTickEvent.Pre event) {
        if (!event.getEntity().level().isClientSide && event.getEntity().tickCount % 20 == 0) {
            VariantUtil.validateVariants(event.getEntity());
        }
    }
}

