/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter;

import com.google.gson.JsonElement;
import dev.tazer.mixed_litter.MLRegistries;
import dev.tazer.mixed_litter.MixedLitter;
import dev.tazer.mixed_litter.registry.MLDataAttachmentTypes;
import dev.tazer.mixed_litter.variants.SelectionMethod;
import dev.tazer.mixed_litter.variants.Variant;
import dev.tazer.mixed_litter.variants.VariantGroup;
import dev.tazer.mixed_litter.variants.VariantType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class VariantUtil {
    public static List<Variant> getVariants(Entity entity) {
        return entity.hasData(MLDataAttachmentTypes.VARIANTS) ? VariantUtil.lookupVariantIds((List)entity.getData(MLDataAttachmentTypes.VARIANTS), entity.registryAccess()) : List.of();
    }

    public static List<Variant> lookupVariantIds(List<ResourceLocation> variants, RegistryAccess access) {
        Registry variantRegistry = access.registryOrThrow(MLRegistries.VARIANT_KEY);
        ArrayList<Variant> variantList = new ArrayList<Variant>(variants.size());
        for (ResourceLocation id : variants) {
            variantRegistry.getOptional(id).ifPresent(variantList::add);
        }
        return variantList;
    }

    public static Variant selectVariant(VariantGroup group, List<Variant> groupVariants, RandomSource random) {
        boolean spawningLocation = false;
        for (Variant variant2 : groupVariants) {
            if (!variant2.conditions().isPresent() || !variant2.conditions().get().spawningLocation().isPresent()) continue;
            spawningLocation = true;
            break;
        }
        if (spawningLocation) {
            groupVariants.removeIf(variant -> variant.conditions().isEmpty() || variant.conditions().get().spawningLocation().isEmpty());
        }
        return switch (group.selection()) {
            default -> throw new MatchException(null, null);
            case SelectionMethod.UNIFORM -> groupVariants.get(random.nextInt(groupVariants.size()));
            case SelectionMethod.WEIGHTED -> {
                Variant chosen = null;
                int cumulative = 0;
                for (Variant variant : groupVariants) {
                    int weight = Optional.ofNullable(variant.arguments().get("weight")).map(JsonElement::getAsInt).orElse(1);
                    if (random.nextInt(cumulative + weight) < weight) {
                        chosen = variant;
                    }
                    cumulative += weight;
                }
                yield chosen;
            }
        };
    }

    public static void applySuitableVariants(Entity entity) {
        ServerLevel serverLevel = (ServerLevel)entity.level();
        Registry variantGroupRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_GROUP_KEY);
        Registry variantRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_KEY);
        ArrayList availableVariants = new ArrayList(variantRegistry.holders().toList());
        ArrayList<Variant> selectedVariants = new ArrayList<Variant>();
        boolean replaceDefault = false;
        for (Holder variantGroupHolder : variantGroupRegistry.holders().toList()) {
            VariantGroup group = (VariantGroup)variantGroupHolder.value();
            if (group.replaceDefault()) {
                replaceDefault = true;
            }
            if (group.conditions().isPresent() && !group.conditions().get().matches(serverLevel, entity.position(), entity)) continue;
            ArrayList<Variant> matchingGroupVariants = new ArrayList<Variant>();
            for (Holder variantHolder : new ArrayList(availableVariants)) {
                Variant variant = (Variant)variantHolder.value();
                variant.group().ifPresent(location -> {
                    if (variantGroupRegistry.get(location) == group) {
                        if (variant.conditions().isEmpty() || variant.conditions().get().matches(serverLevel, entity.position(), entity)) {
                            matchingGroupVariants.add(variant);
                        }
                        availableVariants.remove(variantHolder);
                    }
                });
            }
            if (matchingGroupVariants.isEmpty() || !group.exclusive()) continue;
            selectedVariants.add(VariantUtil.selectVariant(group, matchingGroupVariants, entity.getRandom()));
        }
        for (Holder variantHolder : availableVariants) {
            Variant variant = (Variant)variantHolder.value();
            if (!variant.group().isEmpty() || !variant.conditions().isEmpty() && !variant.conditions().get().matches(serverLevel, entity.position(), entity)) continue;
            selectedVariants.add(variant);
        }
        if (replaceDefault) {
            for (Object variant : new ArrayList(selectedVariants)) {
                ((Variant)variant).group().ifPresent(arg_0 -> VariantUtil.lambda$applySuitableVariants$2(selectedVariants, (Variant)variant, arg_0));
            }
        }
        if (selectedVariants.size() == 1 && ((Variant)selectedVariants.getFirst()).group().isPresent()) {
            ((Variant)selectedVariants.getFirst()).group().ifPresent(location -> {
                if (location.equals((Object)MixedLitter.location("default"))) {
                    selectedVariants.remove(selectedVariants.getFirst());
                }
            });
        }
        HashMap<ResourceLocation, List<Variant>> presentByGroup = new HashMap<ResourceLocation, List<Variant>>();
        for (Variant variant : selectedVariants) {
            if (!variant.group().isPresent()) continue;
            ResourceLocation groupId = variant.group().get();
            presentByGroup.computeIfAbsent(groupId, k -> new ArrayList()).add(variant);
        }
        HashSet unresolved = new HashSet(presentByGroup.keySet());
        while (!unresolved.isEmpty()) {
            ResourceLocation seed = (ResourceLocation)unresolved.iterator().next();
            HashSet<ResourceLocation> cluster = new HashSet<ResourceLocation>();
            ArrayDeque<ResourceLocation> queue = new ArrayDeque<ResourceLocation>();
            queue.add(seed);
            while (!queue.isEmpty()) {
                ResourceLocation current = (ResourceLocation)queue.removeFirst();
                if (!cluster.add(current)) continue;
                VariantGroup currentGroup = (VariantGroup)variantGroupRegistry.get(current);
                if (currentGroup != null && currentGroup.conflicts() != null) {
                    for (ResourceLocation other : currentGroup.conflicts()) {
                        if (!presentByGroup.containsKey(other) || cluster.contains(other)) continue;
                        queue.addLast(other);
                    }
                }
                for (Map.Entry entry : presentByGroup.entrySet()) {
                    VariantGroup candidateGroup;
                    ResourceLocation candidate = (ResourceLocation)entry.getKey();
                    if (candidate.equals((Object)current) || (candidateGroup = (VariantGroup)variantGroupRegistry.get(candidate)) == null || candidateGroup.conflicts() == null || !candidateGroup.conflicts().contains(current) || cluster.contains(candidate)) continue;
                    queue.addLast(candidate);
                }
            }
            if (cluster.size() > 1) {
                ArrayList clusterList = new ArrayList(cluster);
                ResourceLocation winningGroupId = (ResourceLocation)clusterList.get(entity.getRandom().nextInt(clusterList.size()));
                VariantGroup winningGroup = (VariantGroup)variantGroupRegistry.get(winningGroupId);
                List winningCandidates = (List)presentByGroup.get(winningGroupId);
                Variant winningVariant = VariantUtil.selectVariant(winningGroup, winningCandidates, entity.getRandom());
                for (ResourceLocation gid : clusterList) {
                    List toRemove;
                    if (gid.equals((Object)winningGroupId) || (toRemove = (List)presentByGroup.get(gid)) == null) continue;
                    selectedVariants.removeAll(toRemove);
                }
                presentByGroup.put(winningGroupId, Collections.singletonList(winningVariant));
                unresolved.removeAll(clusterList);
                continue;
            }
            unresolved.removeAll(cluster);
        }
        if (!selectedVariants.isEmpty()) {
            VariantUtil.setVariants(entity, selectedVariants);
        }
    }

    public static void setVariants(Entity entity, List<Variant> variants) {
        ArrayList variantLocations = new ArrayList();
        Registry variantRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_KEY);
        variants.forEach(variant -> Optional.ofNullable(variantRegistry.getKey(variant)).map(variantLocations::add));
        if (!variantLocations.isEmpty()) {
            entity.setData(MLDataAttachmentTypes.VARIANTS, variantLocations);
        } else {
            entity.removeData(MLDataAttachmentTypes.VARIANTS);
        }
    }

    public static void setChildVariant(Entity parentA, Entity parentB, Entity child) {
        ArrayList<Variant> AVariants = new ArrayList<Variant>(VariantUtil.getVariants(parentA));
        ArrayList<Variant> BVariants = new ArrayList<Variant>(VariantUtil.getVariants(parentB));
        ServerLevel serverLevel = (ServerLevel)child.level();
        Registry variantGroupRegistry = child.registryAccess().registryOrThrow(MLRegistries.VARIANT_GROUP_KEY);
        Registry variantRegistry = child.registryAccess().registryOrThrow(MLRegistries.VARIANT_KEY);
        ArrayList availableVariants = new ArrayList(variantRegistry.holders().toList());
        ArrayList<Variant> childVariants = new ArrayList<Variant>();
        for (Holder variantGroupHolder : variantGroupRegistry.holders().toList()) {
            VariantGroup group = (VariantGroup)variantGroupHolder.value();
            if (group.conditions().isPresent() && !group.conditions().get().matches(serverLevel, child.position(), child)) continue;
            ArrayList matchingGroupVariants = new ArrayList();
            for (Holder variantHolder : new ArrayList(availableVariants)) {
                Variant variant = (Variant)variantHolder.value();
                if (!AVariants.contains(variant) && !BVariants.contains(variant)) continue;
                variant.group().ifPresent(location -> {
                    if (variantGroupRegistry.get(location) == group) {
                        if (variant.conditions().isEmpty() || variant.conditions().get().matches(serverLevel, child.position(), child)) {
                            matchingGroupVariants.add(variant);
                        }
                        availableVariants.remove(variantHolder);
                    }
                });
            }
            if (matchingGroupVariants.isEmpty() || !group.exclusive()) continue;
            childVariants.add((Variant)matchingGroupVariants.get(child.getRandom().nextInt(matchingGroupVariants.size())));
        }
        for (Holder variantHolder : availableVariants) {
            Variant variant = (Variant)variantHolder.value();
            if (!AVariants.contains(variant) && !BVariants.contains(variant) || !variant.group().isEmpty() || !variant.conditions().isEmpty() && !variant.conditions().get().matches(serverLevel, child.position(), child)) continue;
            childVariants.add((Variant)variantHolder.value());
        }
        if (!childVariants.isEmpty()) {
            VariantUtil.setVariants(child, childVariants);
        }
    }

    public static void validateVariants(Entity entity) {
        VariantGroup group;
        List<Variant> oldVariants = VariantUtil.getVariants(entity);
        ArrayList<Variant> newVariants = new ArrayList<Variant>(oldVariants);
        Registry variantGroupRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_GROUP_KEY);
        Registry variantRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_KEY);
        ServerLevel serverLevel = (ServerLevel)entity.level();
        for (Variant variant : oldVariants) {
            if (variant.group().isPresent()) {
                VariantGroup group2 = (VariantGroup)variantGroupRegistry.get(variant.group().get());
                if (group2 != null) {
                    if (group2.conditions().isPresent() && !group2.conditions().get().matches(serverLevel, entity.position(), entity)) {
                        newVariants.remove(variant);
                        continue;
                    }
                } else {
                    newVariants.remove(variant);
                    continue;
                }
            }
            if (!variant.conditions().isPresent() || variant.conditions().get().matches(serverLevel, entity.position(), entity)) continue;
            newVariants.remove(variant);
        }
        ArrayList availableVariants = new ArrayList(variantRegistry.holders().toList());
        ArrayList<Variant> selectedVariants = new ArrayList<Variant>();
        boolean replaceDefault = false;
        for (Holder variantGroupHolder : variantGroupRegistry.holders().toList()) {
            VariantGroup variantGroup = (VariantGroup)variantGroupHolder.value();
            if (variantGroup.replaceDefault()) {
                replaceDefault = true;
            }
            if (variantGroup.conditions().isPresent() && !variantGroup.conditions().get().matches(serverLevel, entity.position(), entity)) continue;
            ArrayList<Variant> arrayList = new ArrayList<Variant>();
            for (Holder variantHolder : new ArrayList(availableVariants)) {
                Variant variant = (Variant)variantHolder.value();
                variant.group().ifPresent(location -> {
                    if (variantGroupRegistry.get(location) == group3) {
                        if (variant.conditions().isEmpty() || variant.conditions().get().matches(serverLevel, entity.position(), entity)) {
                            matchingGroupVariants.add(variant);
                        }
                        availableVariants.remove(variantHolder);
                    }
                });
            }
            if (arrayList.isEmpty() || !variantGroup.exclusive()) continue;
            selectedVariants.add(VariantUtil.selectVariant(variantGroup, arrayList, entity.getRandom()));
        }
        for (Holder variantHolder : availableVariants) {
            Variant variant = (Variant)variantHolder.value();
            if (!variant.group().isEmpty() || !variant.conditions().isEmpty() && !variant.conditions().get().matches(serverLevel, entity.position(), entity)) continue;
            selectedVariants.add(variant);
        }
        for (Iterator selectedVariant : new ArrayList(selectedVariants)) {
            for (Variant variant : newVariants) {
                if (selectedVariant == variant) {
                    selectedVariants.remove(selectedVariant);
                }
                if (!variant.group().isPresent() || !VariantUtil.getGroup(entity, variant).exclusive() || !((Variant)((Object)selectedVariant)).group().equals(variant.group())) continue;
                selectedVariants.remove(selectedVariant);
            }
        }
        newVariants.addAll(selectedVariants);
        HashMap<ResourceLocation, List> groupedVariants = new HashMap<ResourceLocation, List>();
        for (Variant variant : new ArrayList<Variant>(newVariants)) {
            ResourceLocation resourceLocation;
            if (replaceDefault) {
                variant.group().ifPresent(location -> {
                    if (location.equals((Object)MixedLitter.location("default"))) {
                        newVariants.remove(variant);
                    }
                });
            }
            if (!variant.group().isPresent() || (group = (VariantGroup)variantGroupRegistry.get(resourceLocation = variant.group().get())) == null || !group.exclusive()) continue;
            groupedVariants.computeIfAbsent(resourceLocation, k -> new ArrayList()).add(variant);
        }
        for (Map.Entry entry : groupedVariants.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() <= 1 || (group = (VariantGroup)variantGroupRegistry.get((ResourceLocation)entry.getKey())) == null) continue;
            Variant chosen = VariantUtil.selectVariant(group, list, entity.getRandom());
            newVariants.removeAll(list);
            newVariants.add(chosen);
        }
        if (newVariants.size() == 1 && newVariants.getFirst().group().isPresent()) {
            newVariants.getFirst().group().ifPresent(location -> {
                if (location.equals((Object)MixedLitter.location("default"))) {
                    newVariants.remove(newVariants.getFirst());
                }
            });
        }
        HashMap<ResourceLocation, List> presentByGroup = new HashMap<ResourceLocation, List>();
        for (Variant variant : newVariants) {
            if (!variant.group().isPresent()) continue;
            ResourceLocation groupId = variant.group().get();
            presentByGroup.computeIfAbsent(groupId, k -> new ArrayList()).add(variant);
        }
        HashSet<ResourceLocation> hashSet = new HashSet<ResourceLocation>();
        for (Variant variant : oldVariants) {
            if (!variant.group().isPresent()) continue;
            hashSet.add(variant.group().get());
        }
        HashSet hashSet2 = new HashSet(presentByGroup.keySet());
        while (!hashSet2.isEmpty()) {
            Object conflicts;
            ResourceLocation seed = (ResourceLocation)hashSet2.iterator().next();
            HashSet<ResourceLocation> cluster = new HashSet<ResourceLocation>();
            ArrayDeque<ResourceLocation> queue = new ArrayDeque<ResourceLocation>();
            queue.add(seed);
            while (!queue.isEmpty()) {
                VariantGroup group4;
                ResourceLocation gid = (ResourceLocation)queue.removeFirst();
                if (!cluster.add(gid) || (group4 = (VariantGroup)variantGroupRegistry.get(gid)) == null || (conflicts = group4.conflicts()) == null) continue;
                Iterator<Object> iterator = conflicts.iterator();
                while (iterator.hasNext()) {
                    ResourceLocation resourceLocation = (ResourceLocation)iterator.next();
                    if (!presentByGroup.containsKey(resourceLocation) || cluster.contains(resourceLocation)) continue;
                    queue.addLast(resourceLocation);
                }
                for (Map.Entry entry : presentByGroup.entrySet()) {
                    List<ResourceLocation> back;
                    VariantGroup cg;
                    ResourceLocation candidate = (ResourceLocation)entry.getKey();
                    if (candidate.equals((Object)gid) || (cg = (VariantGroup)variantGroupRegistry.get(candidate)) == null || (back = cg.conflicts()) == null || !back.contains(gid) || cluster.contains(candidate)) continue;
                    queue.addLast(candidate);
                }
            }
            if (cluster.size() > 1) {
                ArrayList clusterList = new ArrayList(cluster);
                ResourceLocation winningGroupId = null;
                conflicts = clusterList.iterator();
                while (conflicts.hasNext()) {
                    ResourceLocation gid = (ResourceLocation)conflicts.next();
                    if (!hashSet.contains(gid)) continue;
                    winningGroupId = gid;
                    break;
                }
                if (winningGroupId == null) {
                    winningGroupId = (ResourceLocation)clusterList.get(entity.getRandom().nextInt(clusterList.size()));
                }
                VariantGroup winningGroup = (VariantGroup)variantGroupRegistry.get(winningGroupId);
                List winningCandidates = (List)presentByGroup.get(winningGroupId);
                Variant variant = VariantUtil.selectVariant(winningGroup, winningCandidates, entity.getRandom());
                for (ResourceLocation gid : clusterList) {
                    List toRemove = (List)presentByGroup.get(gid);
                    if (toRemove == null) continue;
                    newVariants.removeAll(toRemove);
                }
                newVariants.add(variant);
                HashMap<ResourceLocation, List<Variant>> updated = new HashMap<ResourceLocation, List<Variant>>(presentByGroup);
                updated.put(winningGroupId, Collections.singletonList(variant));
                for (ResourceLocation gid : clusterList) {
                    if (gid.equals((Object)winningGroupId)) continue;
                    updated.remove(gid);
                }
                presentByGroup = updated;
                clusterList.forEach(hashSet2::remove);
                continue;
            }
            hashSet2.removeAll(cluster);
        }
        if (!newVariants.equals(oldVariants)) {
            VariantUtil.setVariants(entity, newVariants);
        }
    }

    @Nullable
    public static VariantGroup getGroup(Entity entity, Variant variant) {
        Registry variantGroupRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_GROUP_KEY);
        return variant.group().map(arg_0 -> ((Registry)variantGroupRegistry).get(arg_0)).orElse(null);
    }

    public static VariantType getType(Entity entity, Variant variant) {
        Registry variantTypeRegistry = entity.registryAccess().registryOrThrow(MLRegistries.VARIANT_TYPE_KEY);
        return (VariantType)variantTypeRegistry.get(variant.type());
    }

    private static /* synthetic */ void lambda$applySuitableVariants$2(ArrayList selectedVariants, Variant variant, ResourceLocation location) {
        if (location.equals((Object)MixedLitter.location("default"))) {
            selectedVariants.remove(variant);
        }
    }
}

