/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.tazer.mixed_litter.actions.VariantActionType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ReplaceTextures
implements VariantActionType {
    public Map<ResourceLocation, ResourceLocation> replacements;

    @Override
    public void initialize(JsonObject actionsArgs, JsonObject variantArgs, JsonObject defaultArgs) {
        JsonObject arguments = VariantActionType.resolveArguments((JsonElement)actionsArgs, variantArgs, defaultArgs);
        JsonElement replacementsElement = arguments.get("replacements");
        JsonObject replacementsObject = replacementsElement.getAsJsonObject();
        HashMap<ResourceLocation, ResourceLocation> map = new HashMap<ResourceLocation, ResourceLocation>();
        for (Map.Entry entry : replacementsObject.entrySet()) {
            String fromKey = (String)entry.getKey();
            JsonElement toValueElement = (JsonElement)entry.getValue();
            ResourceLocation from = ResourceLocation.parse((String)fromKey).withPath(path -> "textures/" + path + ".png");
            ResourceLocation to = ResourceLocation.parse((String)toValueElement.getAsString()).withPath(path -> "textures/" + path + ".png");
            map.put(from, to);
        }
        this.replacements = map;
    }
}

