/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;

public class ChickenRemodel<T extends AgeableMob>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart bodyAdult;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart bodyBaby;
    private final ModelPart headBaby;
    private final ModelPart rightLegBaby;
    private final ModelPart leftLegBaby;

    public ChickenRemodel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.bodyAdult = this.body.getChild("body_adult");
        this.rightWing = root.getChild("right_wing");
        this.leftWing = root.getChild("left_wing");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.bodyBaby = this.body.getChild("body_baby");
        this.headBaby = this.bodyBaby.getChild("head_baby");
        this.rightLegBaby = this.bodyBaby.getChild("right_leg_baby");
        this.leftLegBaby = this.bodyBaby.getChild("left_leg_baby");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyAdult = body.addOrReplaceChild("body_adult", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.5f, -3.5f, 5.0f, 5.0f, 7.0f), PartPose.offset((float)0.0f, (float)18.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("red_thing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 0).addBox(-1.5f, -5.0f, -2.0f, 3.0f, 4.0f, 3.0f).texOffs(0, 0).addBox(-0.5f, -4.0f, -4.0f, 1.0f, 2.0f, 2.0f).texOffs(35, 7).addBox(0.0f, -7.0f, -3.0f, 0.0f, 7.0f, 3.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-2.5f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(38, 0).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)1.0f, (float)21.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(38, 0).mirror().addBox(-1.5f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f).mirror(false), PartPose.offset((float)-1.0f, (float)21.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(30, 0).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)2.5f, (float)16.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(30, 0).mirror().addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f).mirror(false), PartPose.offset((float)-2.5f, (float)16.0f, (float)-0.5f));
        bodyAdult.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(19, 8).addBox(-1.5f, -3.0f, -1.0f, 3.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)3.5f));
        PartDefinition bodyBaby = body.addOrReplaceChild("body_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.5f, -1.0f, 4.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)16.9f, (float)-0.5f));
        bodyBaby.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 3.0f, 3.0f).texOffs(12, 0).addBox(-0.5f, -1.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        bodyBaby.addOrReplaceChild("right_leg_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)-1.0f, (float)1.5f, (float)1.0f));
        bodyBaby.addOrReplaceChild("left_leg_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)1.0f, (float)1.5f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T chicken, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean baby = chicken.isBaby();
        this.bodyBaby.xScale = 2.0f;
        this.bodyBaby.yScale = 2.0f;
        this.bodyBaby.zScale = 2.0f;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.headBaby.xRot = this.head.xRot / 2.0f;
        this.headBaby.yRot = this.head.yRot / 2.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
        this.bodyAdult.visible = !baby;
        this.head.visible = !baby;
        this.leftLeg.visible = !baby;
        this.rightLeg.visible = !baby;
        this.leftWing.visible = !baby;
        this.rightWing.visible = !baby;
        this.bodyBaby.visible = baby;
        this.rightLegBaby.xRot = this.rightLeg.xRot;
        this.leftLegBaby.xRot = this.leftLeg.xRot;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing);
    }
}

