/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.buzzier_bees.common.entity.animal.Moobloom;
import dev.tazer.mixed_litter.client.ModelLayers;
import dev.tazer.mixed_litter.client.models.CowRemodel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.level.block.state.BlockState;

public class MoobloomFlowerLayer<T extends Moobloom>
extends RenderLayer<T, CowModel<T>> {
    private CowRemodel<Moobloom> cowRemodel;

    public MoobloomFlowerLayer(RenderLayerParent<T, CowModel<T>> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.cowRemodel = new CowRemodel(modelSet.bakeLayer(ModelLayers.COW_LAYER));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, T moobloom, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!moobloom.isBaby() && !moobloom.isInvisible()) {
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            BlockState blockstate = moobloom.getFlower().defaultBlockState();
            int i = LivingEntityRenderer.getOverlayCoords(moobloom, (float)0.0f);
            poseStack.pushPose();
            poseStack.translate(0.2f, -0.4f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            dispatcher.renderSingleBlock(blockstate, poseStack, buffer, packedLightIn, i);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.2f, -0.4f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(42.0f));
            poseStack.translate(0.1f, 0.0f, -0.6f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            dispatcher.renderSingleBlock(blockstate, poseStack, buffer, packedLightIn, i);
            poseStack.popPose();
            poseStack.pushPose();
            this.cowRemodel.getHead().translateAndRotate(poseStack);
            poseStack.translate(0.0f, -0.7f, -0.2f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-78.0f));
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            dispatcher.renderSingleBlock(blockstate, poseStack, buffer, packedLightIn, i);
            poseStack.popPose();
        }
    }
}

