/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.actions.Action;
import dev.tazer.mixed_litter.actions.SetMooshroomMushroom;
import dev.tazer.mixed_litter.actions.VariantActionType;
import dev.tazer.mixed_litter.client.ModelLayers;
import dev.tazer.mixed_litter.client.models.CowRemodel;
import dev.tazer.mixed_litter.variants.Variant;
import dev.tazer.mixed_litter.variants.VariantType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MooshroomMushroomLayer<T extends MushroomCow>
extends RenderLayer<T, CowModel<T>> {
    private final BlockRenderDispatcher blockRenderer;
    private CowRemodel<MushroomCow> cowRemodel;

    public MooshroomMushroomLayer(RenderLayerParent<T, CowModel<T>> renderer, BlockRenderDispatcher blockRenderer, EntityModelSet modelSet) {
        super(renderer);
        this.blockRenderer = blockRenderer;
        this.cowRemodel = new CowRemodel(modelSet.bakeLayer(ModelLayers.COW_LAYER));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!livingEntity.isBaby()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (!livingEntity.isInvisible() || minecraft.shouldEntityAppearGlowing(livingEntity)) {
                Block mushroom = null;
                block0: for (Variant variant : VariantUtil.getVariants(livingEntity)) {
                    VariantType variantType = VariantUtil.getType(livingEntity, variant);
                    for (Action action : variantType.actions()) {
                        VariantActionType actionType = action.type();
                        actionType.initialize(action.arguments(), variant.arguments(), variantType.defaults());
                        if (!(actionType instanceof SetMooshroomMushroom)) continue;
                        SetMooshroomMushroom setMooshroomMushroom = (SetMooshroomMushroom)actionType;
                        mushroom = setMooshroomMushroom.mushroom;
                        continue block0;
                    }
                }
                if (mushroom != null) {
                    boolean outlineOnly = minecraft.shouldEntityAppearGlowing(livingEntity) && livingEntity.isInvisible();
                    BlockState blockstate = mushroom.defaultBlockState();
                    int i = LivingEntityRenderer.getOverlayCoords(livingEntity, (float)0.0f);
                    BakedModel bakedmodel = this.blockRenderer.getBlockModel(blockstate);
                    poseStack.pushPose();
                    poseStack.translate(0.2f, -0.35f, 0.5f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    poseStack.translate(-0.5f, -0.3f, -0.5f);
                    this.renderMushroomBlock(poseStack, buffer, packedLight, outlineOnly, blockstate, i, bakedmodel);
                    poseStack.popPose();
                    poseStack.pushPose();
                    poseStack.translate(0.2f, -0.35f, 0.5f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(42.0f));
                    poseStack.translate(0.1f, 0.0f, -0.6f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    poseStack.translate(-0.5f, -0.3f, -0.5f);
                    this.renderMushroomBlock(poseStack, buffer, packedLight, outlineOnly, blockstate, i, bakedmodel);
                    poseStack.popPose();
                    poseStack.pushPose();
                    this.cowRemodel.getHead().translateAndRotate(poseStack);
                    poseStack.translate(0.0f, -0.6f, -0.2f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(-78.0f));
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    poseStack.translate(-0.5f, -0.3f, -0.5f);
                    this.renderMushroomBlock(poseStack, buffer, packedLight, outlineOnly, blockstate, i, bakedmodel);
                    poseStack.popPose();
                }
            }
        }
    }

    private void renderMushroomBlock(PoseStack poseStack, MultiBufferSource buffer, int packedLight, boolean outlineOnly, BlockState state, int packedOverlay, BakedModel model) {
        if (outlineOnly) {
            this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), state, model, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        } else {
            this.blockRenderer.renderSingleBlock(state, poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

