/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;

public class PigRemodel<T extends AgeableMob>
extends QuadrupedModel<T> {
    private final ModelPart headBaby;
    private final ModelPart rightFrontLegBaby;
    private final ModelPart leftFrontLegBaby;
    private final ModelPart rightHindLegBaby;
    private final ModelPart leftHindLegBaby;
    private final ModelPart rightEar;
    private final ModelPart leftEar;

    public PigRemodel(ModelPart root) {
        super(root, false, 4.0f, 4.0f, 2.0f, 2.0f, 24);
        this.headBaby = this.body.getChild("head_baby");
        this.rightFrontLegBaby = this.headBaby.getChild("right_front_leg_baby");
        this.leftFrontLegBaby = this.headBaby.getChild("left_front_leg_baby");
        this.rightHindLegBaby = this.headBaby.getChild("right_hind_leg_baby");
        this.leftHindLegBaby = this.headBaby.getChild("left_hind_leg_baby");
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.0f, -8.0f, 10.0f, 10.0f, 16.0f).texOffs(0, 26).addBox(-5.0f, -5.0f, -9.0f, 10.0f, 5.0f, 1.0f).texOffs(22, 26).mirror().addBox(-3.0f, 2.0f, -11.0f, 2.0f, 2.0f, 3.0f).mirror(false).texOffs(32, 26).mirror().addBox(1.0f, 2.0f, -11.0f, 2.0f, 2.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(0, 6).addBox(-2.0f, -1.5f, -2.0f, 4.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)-8.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(36, 0).mirror().addBox(-1.0f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.2443f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(36, 0).addBox(0.0f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)5.0f, (float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.2443f));
        head.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -4.5f, 0.0f, 0.0f, 5.0f, 4.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)8.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(36, 8).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)-3.4f, (float)21.0f, (float)-4.5f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(36, 8).mirror().addBox(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f).mirror(false), PartPose.offset((float)3.4f, (float)21.0f, (float)-4.5f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f).mirror(false), PartPose.offset((float)-3.4f, (float)21.0f, (float)6.5f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f).mirror(false), PartPose.offset((float)3.4f, (float)21.0f, (float)6.5f));
        PartDefinition headBaby = body.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.5f, -4.0f, 5.0f, 5.0f, 8.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        headBaby.addOrReplaceChild("snout_baby", CubeListBuilder.create().texOffs(18, 0).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)-4.0f));
        headBaby.addOrReplaceChild("right_ear_baby", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f).mirror(false), PartPose.offset((float)-2.5f, (float)-2.5f, (float)-2.5f));
        headBaby.addOrReplaceChild("left_ear_baby", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f), PartPose.offset((float)2.5f, (float)-2.5f, (float)-2.5f));
        headBaby.addOrReplaceChild("tail_baby", CubeListBuilder.create().texOffs(18, 0).addBox(0.0f, -2.5f, 0.0f, 0.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        headBaby.addOrReplaceChild("right_front_leg_baby", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offset((float)-1.5f, (float)2.5f, (float)-2.0f));
        headBaby.addOrReplaceChild("left_front_leg_baby", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)1.5f, (float)2.5f, (float)-2.0f));
        headBaby.addOrReplaceChild("right_hind_leg_baby", CubeListBuilder.create().texOffs(8, 13).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offset((float)-1.5f, (float)2.5f, (float)3.0f));
        headBaby.addOrReplaceChild("left_hind_leg_baby", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)1.5f, (float)2.5f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T pig, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean baby = pig.isBaby();
        this.headBaby.xScale = 2.0f;
        this.headBaby.yScale = 2.0f;
        this.headBaby.zScale = 2.0f;
        if (!pig.hasControllingPassenger()) {
            this.head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        }
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) / 4.0f;
        this.headBaby.xRot = this.head.xRot / 2.0f;
        this.headBaby.yRot = this.head.yRot / 2.0f;
        this.body.xRot = this.head.xRot;
        this.body.yRot = this.head.yRot;
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
        this.head.visible = !baby;
        this.leftHindLeg.visible = !baby;
        this.rightHindLeg.visible = !baby;
        this.leftFrontLeg.visible = !baby;
        this.rightFrontLeg.visible = !baby;
        this.headBaby.visible = baby;
        if (!pig.onGround()) {
            this.rightEar.zRot = (float)Mth.lerp((double)0.5, (double)this.rightEar.zRot, (double)pig.getDeltaMovement().length());
        } else if (limbSwing > 0.0f) {
            this.rightEar.zRot = (float)Mth.lerp((double)0.5, (double)this.rightEar.zRot, (double)(Mth.abs((float)Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI))) * limbSwingAmount / 2.0f));
        }
        this.leftEar.zRot = -this.rightEar.zRot;
        this.rightHindLegBaby.xRot = this.rightHindLeg.xRot;
        this.leftHindLegBaby.xRot = this.leftHindLeg.xRot;
        this.rightFrontLegBaby.xRot = this.rightFrontLeg.xRot;
        this.leftFrontLegBaby.xRot = this.leftFrontLeg.xRot;
    }
}

