/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Rabbit;

public class RabbitRemodel<T extends Rabbit>
extends EntityModel<T> {
    private final ModelPart leftRearFoot;
    private final ModelPart rightRearFoot;
    private final ModelPart leftHaunch;
    private final ModelPart rightHaunch;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart head;
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final ModelPart tail;
    private final ModelPart nose;
    private float jumpRotation;

    public RabbitRemodel(ModelPart root) {
        this.leftRearFoot = root.getChild("left_hind_foot");
        this.rightRearFoot = root.getChild("right_hind_foot");
        this.leftHaunch = root.getChild("left_haunch");
        this.rightHaunch = root.getChild("right_haunch");
        this.body = root.getChild("body");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.head = root.getChild("head");
        this.rightEar = root.getChild("right_ear");
        this.leftEar = root.getChild("left_ear");
        this.tail = root.getChild("tail");
        this.nose = root.getChild("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(16, 0).addBox(-1.5f, -3.0f, -4.0f, 3.0f, 3.0f, 5.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)-1.5f));
        PartDefinition right_front_leg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f).mirror(false), PartPose.offset((float)-1.0f, (float)21.0f, (float)-2.0f));
        PartDefinition left_front_leg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)1.0f, (float)21.0f, (float)-2.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(19, 8).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)20.0f, (float)2.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -7.0f, -2.5f, 3.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_haunch = partdefinition.addOrReplaceChild("right_haunch", CubeListBuilder.create().texOffs(0, 9).addBox(-1.5f, -1.0f, 0.0f, 2.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)-1.5f, (float)20.0f, (float)1.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition right_foot = right_haunch.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(10, 9).mirror().addBox(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offset((float)-0.5f, (float)3.0f, (float)0.0f));
        PartDefinition left_haunch = partdefinition.addOrReplaceChild("left_haunch", CubeListBuilder.create().texOffs(0, 9).mirror().addBox(-0.5f, -1.0f, 0.0f, 2.0f, 5.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)20.0f, (float)1.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition left_foot = left_haunch.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(10, 9).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.5f, (float)3.0f, (float)0.0f));
        PartDefinition right_ear = partdefinition.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(24, 12).mirror().addBox(-1.5f, -6.0f, 0.0f, 2.0f, 6.0f, 1.0f).mirror(false), PartPose.offset((float)-1.0f, (float)14.0f, (float)-1.5f));
        PartDefinition left_ear = partdefinition.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(24, 12).addBox(-0.5f, -6.0f, 0.0f, 2.0f, 6.0f, 1.0f), PartPose.offset((float)1.0f, (float)14.0f, (float)-1.5f));
        PartDefinition nose = partdefinition.addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_hind_foot = partdefinition.addOrReplaceChild("left_hind_foot", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_foot = partdefinition.addOrReplaceChild("right_hind_foot", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T rabbit, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((Rabbit)rabbit).tickCount;
        this.nose.xRot = headPitch * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightEar.xRot = headPitch * ((float)Math.PI / 180);
        this.leftEar.xRot = headPitch * ((float)Math.PI / 180);
        this.nose.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightEar.yRot = this.nose.yRot - 0.2617994f;
        this.leftEar.yRot = this.nose.yRot + 0.2617994f;
        this.jumpRotation = Mth.sin((float)(rabbit.getJumpCompletion(f) * (float)Math.PI));
        this.leftHaunch.xRot = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rightHaunch.xRot = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.leftRearFoot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rightRearFoot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.leftFrontLeg.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rightFrontLeg.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rightHaunch.xRot += 0.36651915f;
        this.leftHaunch.xRot += 0.36651915f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.translate(0.0, 1.490625, 0.0);
            ImmutableList.of((Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail, (Object)this.head, (Object)this.leftEar, (Object)this.rightEar, (Object)this.nose).forEach(p_349849_ -> p_349849_.render(poseStack, buffer, packedLight, packedOverlay, color));
            poseStack.popPose();
        } else {
            poseStack.pushPose();
            poseStack.scale(0.75f, 0.75f, 0.75f);
            poseStack.translate(0.0, 0.5, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.head, (Object)this.rightEar, (Object)this.leftEar, (Object)this.tail, (Object)this.nose, (Object[])new ModelPart[0]).forEach(p_349861_ -> p_349861_.render(poseStack, buffer, packedLight, packedOverlay, color));
            poseStack.popPose();
        }
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        this.jumpRotation = Mth.sin((float)(entity.getJumpCompletion(partialTick) * (float)Math.PI));
    }
}

