/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.Sheep;

public class SheepRemodel<T extends Sheep>
extends QuadrupedModel<T> {
    private float headXRot;
    private final ModelPart bodyAdult;
    private final ModelPart bodyWool;
    private final ModelPart rightFrontLegWool;
    private final ModelPart leftFrontLegWool;
    private final ModelPart rightHindLegWool;
    private final ModelPart leftHindLegWool;
    private final ModelPart headBaby;
    private final ModelPart bodyBaby;
    private final ModelPart rightFrontLegBaby;
    private final ModelPart leftFrontLegBaby;
    private final ModelPart rightHindLegBaby;
    private final ModelPart leftHindLegBaby;
    private final ModelPart shearedTail;

    public SheepRemodel(ModelPart root) {
        super(root, false, 8.0f, 4.0f, 2.0f, 2.0f, 24);
        this.bodyAdult = this.body.getChild("body_adult");
        this.bodyWool = this.bodyAdult.getChild("body_wool");
        this.rightHindLegWool = this.rightHindLeg.getChild("right_hind_leg_wool");
        this.leftHindLegWool = this.leftHindLeg.getChild("left_hind_leg_wool");
        this.rightFrontLegWool = this.rightFrontLeg.getChild("right_front_leg_wool");
        this.leftFrontLegWool = this.leftFrontLeg.getChild("left_front_leg_wool");
        this.headBaby = this.body.getChild("head_baby");
        this.bodyBaby = this.body.getChild("body_baby");
        this.rightFrontLegBaby = this.bodyBaby.getChild("right_front_leg_baby");
        this.leftFrontLegBaby = this.bodyBaby.getChild("left_front_leg_baby");
        this.rightHindLegBaby = this.bodyBaby.getChild("right_hind_leg_baby");
        this.leftHindLegBaby = this.bodyBaby.getChild("left_hind_leg_baby");
        this.shearedTail = this.bodyAdult.getChild("sheared_tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_adult = body.addOrReplaceChild("body_adult", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -7.0f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)-1.0f));
        PartDefinition sheared_tail = body_adult.addOrReplaceChild("sheared_tail", CubeListBuilder.create().texOffs(0, 3).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)7.0f));
        PartDefinition body_wool = body_adult.addOrReplaceChild("body_wool", CubeListBuilder.create().texOffs(45, 1).addBox(-4.5f, -4.5f, -7.0f, 9.0f, 9.0f, 15.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_wool = body_wool.addOrReplaceChild("tail_wool", CubeListBuilder.create().texOffs(52, 9).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-2.3f, (float)8.3f));
        PartDefinition body_baby = body.addOrReplaceChild("body_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.5f, -4.0f, 5.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition tail_baby = body_baby.addOrReplaceChild("tail_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)4.0f));
        PartDefinition right_front_leg_baby = body_baby.addOrReplaceChild("right_front_leg_baby", CubeListBuilder.create().texOffs(14, 13).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)2.5f, (float)-3.0f));
        PartDefinition left_front_leg_baby = body_baby.addOrReplaceChild("left_front_leg_baby", CubeListBuilder.create().texOffs(14, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)2.5f, (float)-3.0f));
        PartDefinition right_hind_leg_baby = body_baby.addOrReplaceChild("right_hind_leg_baby", CubeListBuilder.create().texOffs(22, 13).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)2.5f, (float)3.0f));
        PartDefinition left_hind_leg_baby = body_baby.addOrReplaceChild("left_hind_leg_baby", CubeListBuilder.create().texOffs(22, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)2.5f, (float)3.0f));
        PartDefinition head_baby = body.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, -1.0778f, -3.0015f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-16.0f, (float)-5.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear_baby = head_baby.addOrReplaceChild("right_ear_baby", CubeListBuilder.create().texOffs(0, 4).mirror().addBox(-1.5f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0829f, (float)-1.693f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition left_ear_baby = head_baby.addOrReplaceChild("left_ear_baby", CubeListBuilder.create().texOffs(0, 4).addBox(-0.75f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0829f, (float)-1.693f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(94, 0).addBox(-2.0f, -3.0f, -1.0f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-3.0f, -4.0f, -5.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)-8.0f, (float)-0.2738f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.0f, 0.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-0.9f, (float)-3.0f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)-0.9f, (float)-2.5f));
        PartDefinition right_front_leg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(30, 0).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.4f, (float)16.0f, (float)-5.5f));
        PartDefinition right_front_leg_wool = right_front_leg.addOrReplaceChild("right_front_leg_wool", CubeListBuilder.create().texOffs(78, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(42, 0).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.4f, (float)16.0f, (float)-5.5f));
        PartDefinition left_front_leg_wool = left_front_leg.addOrReplaceChild("left_front_leg_wool", CubeListBuilder.create().texOffs(78, 8).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(24, 22).mirror().addBox(-1.5f, -2.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.4f, (float)16.0f, (float)5.5f));
        PartDefinition right_hind_leg_wool = right_hind_leg.addOrReplaceChild("right_hind_leg_wool", CubeListBuilder.create().texOffs(48, 25).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_hind_leg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(36, 22).mirror().addBox(-1.5f, -2.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.4f, (float)16.0f, (float)5.5f));
        PartDefinition left_hind_leg_wool = left_hind_leg.addOrReplaceChild("left_hind_leg_wool", CubeListBuilder.create().texOffs(64, 25).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(T sheep, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(sheep, limbSwing, limbSwingAmount, partialTick);
        this.head.y = 11.0f + sheep.getHeadEatPositionScale(partialTick) * 7.0f;
        this.headXRot = sheep.getHeadEatAngleScale(partialTick);
    }

    public void setupAnim(T sheep, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(sheep, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.xRot = this.headXRot;
        boolean baby = sheep.isBaby();
        boolean sheared = sheep.isSheared();
        this.head.xRot = this.headXRot - 0.1569f;
        this.headBaby.xScale = 2.0f;
        this.headBaby.yScale = 2.0f;
        this.headBaby.zScale = 2.0f;
        this.bodyBaby.xScale = 2.0f;
        this.bodyBaby.yScale = 2.0f;
        this.bodyBaby.zScale = 2.0f;
        this.headBaby.xRot = this.headXRot - 0.5412f;
        this.headBaby.y = this.head.y - 27.0f;
        this.headBaby.yRot = this.head.yRot / 2.0f;
        this.bodyBaby.visible = baby;
        this.headBaby.visible = baby;
        this.bodyAdult.visible = !baby;
        this.head.visible = !baby;
        this.leftHindLeg.visible = !baby;
        this.rightHindLeg.visible = !baby;
        this.leftFrontLeg.visible = !baby;
        this.rightFrontLeg.visible = !baby;
        this.shearedTail.visible = sheared;
        this.leftHindLegWool.visible = !sheared;
        this.rightHindLegWool.visible = !sheared;
        this.leftFrontLegWool.visible = !sheared;
        this.rightFrontLegWool.visible = !sheared;
        this.bodyWool.visible = !sheared;
        this.rightHindLegBaby.xRot = this.rightHindLeg.xRot;
        this.leftHindLegBaby.xRot = this.leftHindLeg.xRot;
        this.rightFrontLegBaby.xRot = this.rightFrontLeg.xRot;
        this.leftFrontLegBaby.xRot = this.leftFrontLeg.xRot;
    }
}

