/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.client.models;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class SquidRemodel<T extends LivingEntity>
extends HierarchicalModel<T> {
    private final ModelPart[] tentacles = new ModelPart[8];
    private final ModelPart root;

    public SquidRemodel(ModelPart root) {
        this.root = root;
        Arrays.setAll(this.tentacles, p_170995_ -> root.getChild(SquidRemodel.createTentacleName(p_170995_)));
    }

    private static String createTentacleName(int index) {
        return "tentacle" + index;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 12.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        body.addOrReplaceChild("crown", CubeListBuilder.create().texOffs(0, 28).addBox(-8.0f, -8.0f, -1.0f, 16.0f, 16.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        partdefinition.addOrReplaceChild("tentacle0", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f).texOffs(0, 0).addBox(-2.0f, 18.0f, -1.0f, 4.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)5.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        partdefinition.addOrReplaceChild("tentacle1", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.offsetAndRotation((float)3.5f, (float)11.0f, (float)3.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        partdefinition.addOrReplaceChild("tentacle2", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.offset((float)0.0f, (float)11.0f, (float)5.0f));
        partdefinition.addOrReplaceChild("tentacle3", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.offsetAndRotation((float)-3.5f, (float)11.0f, (float)3.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        partdefinition.addOrReplaceChild("tentacle4", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f).texOffs(0, 0).addBox(-2.0f, 18.0f, -1.0f, 4.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)-5.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partdefinition.addOrReplaceChild("tentacle5", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.offsetAndRotation((float)-3.5f, (float)11.0f, (float)-3.5f, (float)0.0f, (float)-2.3562f, (float)0.0f));
        partdefinition.addOrReplaceChild("tentacle6", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)11.0f, (float)-5.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        partdefinition.addOrReplaceChild("tentacle7", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.offsetAndRotation((float)3.5f, (float)11.0f, (float)-3.5f, (float)0.0f, (float)-3.927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T squid, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ModelPart modelpart : this.tentacles) {
            modelpart.xRot = ageInTicks;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

