/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.tazer.mixed_litter.Config;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.actions.Action;
import dev.tazer.mixed_litter.actions.ReplaceTextures;
import dev.tazer.mixed_litter.actions.SetAgeableTexture;
import dev.tazer.mixed_litter.actions.SetTexture;
import dev.tazer.mixed_litter.actions.VariantActionType;
import dev.tazer.mixed_litter.client.ModelLayers;
import dev.tazer.mixed_litter.client.models.ChickenRemodel;
import dev.tazer.mixed_litter.client.models.CowRemodel;
import dev.tazer.mixed_litter.client.models.PigRemodel;
import dev.tazer.mixed_litter.client.models.RabbitRemodel;
import dev.tazer.mixed_litter.client.models.SheepRemodel;
import dev.tazer.mixed_litter.client.models.SquidRemodel;
import dev.tazer.mixed_litter.variants.Variant;
import dev.tazer.mixed_litter.variants.VariantType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=999)
public class RenderEntityVariantMixin<T extends LivingEntity, M extends EntityModel<T>> {
    @Shadow
    protected M model;
    @Unique
    private static EntityRendererProvider.Context CONTEXT = null;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void LivingEntityRenderer(EntityRendererProvider.Context context, EntityModel<?> model, float shadowRadius, CallbackInfo ci) {
        CONTEXT = context;
    }

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")})
    public void storeRenderTypeVariables(T livingEntity, boolean bodyVisible, boolean translucent, boolean glowing, CallbackInfoReturnable<RenderType> cir) {
        if (Config.STARTUP_CONFIG.isLoaded()) {
            String key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType()).toString();
            if (livingEntity instanceof AgeableMob) {
                if (((Boolean)Config.PIG_REMODEL.get()).booleanValue() && livingEntity instanceof Saddleable && ((List)Config.PIGS.get()).contains(key) && this.model instanceof PigModel) {
                    this.model = new PigRemodel(CONTEXT.bakeLayer(ModelLayers.PIG_LAYER));
                }
                if (((Boolean)Config.CHICKEN_REMODEL.get()).booleanValue() && ((List)Config.CHICKENS.get()).contains(key) && this.model instanceof ChickenModel) {
                    this.model = new ChickenRemodel(CONTEXT.bakeLayer(ModelLayers.CHICKEN_LAYER));
                }
                if (((Boolean)Config.COW_REMODEL.get()).booleanValue() && ((List)Config.COWS.get()).contains(key) && this.model instanceof CowModel) {
                    this.model = new CowRemodel(CONTEXT.bakeLayer(ModelLayers.COW_LAYER));
                }
            }
            if (((Boolean)Config.SHEEP_REMODEL.get()).booleanValue() && livingEntity instanceof Sheep && ((List)Config.SHEEP.get()).contains(key) && this.model instanceof SheepModel) {
                this.model = new SheepRemodel(CONTEXT.bakeLayer(ModelLayers.SHEEP_LAYER));
            }
            if (((Boolean)Config.SQUID_REMODEL.get()).booleanValue() && ((List)Config.SQUIDS.get()).contains(key) && this.model instanceof SquidModel) {
                this.model = new SquidRemodel(CONTEXT.bakeLayer(ModelLayers.SQUID_LAYER));
            }
            if (((Boolean)Config.RABBIT_REMODEL.get()).booleanValue() && livingEntity instanceof Rabbit && ((List)Config.RABBITS.get()).contains(key) && this.model instanceof RabbitModel) {
                this.model = new RabbitRemodel(CONTEXT.bakeLayer(ModelLayers.RABBIT_LAYER));
            }
        }
    }

    @ModifyVariable(method={"getRenderType"}, at=@At(value="STORE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;getTextureLocation(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/resources/ResourceLocation;"))
    public ResourceLocation getVariantTexture(ResourceLocation value, @Local(argsOnly=true) T livingEntity) {
        if (livingEntity != null) {
            List<Variant> variants = VariantUtil.getVariants(livingEntity);
            for (Variant variant : variants) {
                VariantType variantType = VariantUtil.getType(livingEntity, variant);
                block6: for (Action action : variantType.actions()) {
                    VariantActionType variantActionType;
                    VariantActionType actionType = action.type();
                    actionType.initialize(action.arguments(), variant.arguments(), variantType.defaults());
                    Objects.requireNonNull(actionType);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SetTexture.class, SetAgeableTexture.class, ReplaceTextures.class}, (Object)variantActionType, n)) {
                        case 0: {
                            SetTexture setTexture = (SetTexture)variantActionType;
                            return setTexture.texture;
                        }
                        case 1: {
                            AgeableMob ageableMob;
                            SetAgeableTexture setAgeableTexture = (SetAgeableTexture)variantActionType;
                            return livingEntity instanceof AgeableMob && (ageableMob = (AgeableMob)livingEntity).isBaby() ? setAgeableTexture.babyTexture : setAgeableTexture.texture;
                        }
                        case 2: {
                            ReplaceTextures replaceTextures = (ReplaceTextures)variantActionType;
                            for (Map.Entry<ResourceLocation, ResourceLocation> resourceLocationEntry : replaceTextures.replacements.entrySet()) {
                                if (!value.equals((Object)resourceLocationEntry.getKey())) continue;
                                return resourceLocationEntry.getValue();
                            }
                            continue block6;
                        }
                    }
                }
            }
        }
        return value;
    }
}

