/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.actions;

import dev.tazer.mixed_litter.MLRegistries;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.actions.Action;
import dev.tazer.mixed_litter.actions.SetMooshroomMushroom;
import dev.tazer.mixed_litter.actions.VariantActionType;
import dev.tazer.mixed_litter.variants.Variant;
import dev.tazer.mixed_litter.variants.VariantGroup;
import dev.tazer.mixed_litter.variants.VariantType;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.EventHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MushroomCow.class})
public abstract class SetMooshroomMushroomMixin {
    @Shadow
    @Nullable
    private UUID lastLightningBoltUUID;
    @Unique
    MushroomCow self = (MushroomCow)this;

    @Inject(method={"thunderHit"}, at={@At(value="HEAD")}, cancellable=true)
    private void thunderRandomisesVariant(ServerLevel level, LightningBolt lightning, CallbackInfo ci) {
        UUID uuid = lightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            Registry variantGroupRegistry = this.self.registryAccess().registryOrThrow(MLRegistries.VARIANT_GROUP_KEY);
            Registry variantRegistry = this.self.registryAccess().registryOrThrow(MLRegistries.VARIANT_KEY);
            ArrayList availableVariants = new ArrayList(variantRegistry.holders().toList());
            ArrayList<Variant> selectedVariants = new ArrayList<Variant>();
            availableVariants.removeIf(variant -> {
                VariantType variantType = VariantUtil.getType((Entity)this.self, (Variant)variant.value());
                return variantType.actions().stream().filter(action -> action.type() instanceof SetMooshroomMushroom).toList().isEmpty();
            });
            for (Holder variantGroupHolder : variantGroupRegistry.holders().toList()) {
                VariantGroup group = (VariantGroup)variantGroupHolder.value();
                if (group.conditions().isPresent() && !group.conditions().get().matches(level, this.self.position(), (Entity)this.self)) continue;
                ArrayList<Variant> matchingGroupVariants = new ArrayList<Variant>();
                for (Holder variantHolder : new ArrayList(availableVariants)) {
                    Variant variant2 = (Variant)variantHolder.value();
                    variant2.group().ifPresent(location -> {
                        if (variantGroupRegistry.get(location) == group) {
                            if (variant2.conditions().isEmpty() || variant2.conditions().get().matches(level, this.self.position(), (Entity)this.self)) {
                                matchingGroupVariants.add(variant2);
                            }
                            availableVariants.remove(variantHolder);
                        }
                    });
                }
                if (matchingGroupVariants.isEmpty() || !group.exclusive()) continue;
                selectedVariants.add(VariantUtil.selectVariant(group, matchingGroupVariants, this.self.getRandom()));
            }
            for (Holder variantHolder : availableVariants) {
                Variant variant3 = (Variant)variantHolder.value();
                if (!variant3.group().isEmpty() || !variant3.conditions().isEmpty() && !variant3.conditions().get().matches(level, this.self.position(), (Entity)this.self)) continue;
                selectedVariants.add(variant3);
            }
            if (!selectedVariants.isEmpty()) {
                VariantUtil.setVariants((Entity)this.self, selectedVariants);
            }
        }
        ci.cancel();
    }

    @Redirect(method={"mobInteract"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/MushroomCow;getVariant()Lnet/minecraft/world/entity/animal/MushroomCow$MushroomType;"))
    private MushroomCow.MushroomType hasBrownMushroom(MushroomCow instance) {
        Block mushroom = null;
        block0: for (Variant variant : VariantUtil.getVariants((Entity)this.self)) {
            VariantType variantType = VariantUtil.getType((Entity)this.self, variant);
            for (Action action : variantType.actions()) {
                VariantActionType actionType = action.type();
                actionType.initialize(action.arguments(), variant.arguments(), variantType.defaults());
                if (!(actionType instanceof SetMooshroomMushroom)) continue;
                SetMooshroomMushroom setMooshroomMushroom = (SetMooshroomMushroom)actionType;
                mushroom = setMooshroomMushroom.mushroom;
                continue block0;
            }
        }
        return mushroom == Blocks.BROWN_MUSHROOM ? MushroomCow.MushroomType.BROWN : MushroomCow.MushroomType.RED;
    }

    @Inject(method={"shear"}, at={@At(value="HEAD")}, cancellable=true)
    private void shear(SoundSource category, CallbackInfo ci) {
        Level level = this.self.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block mushroom = null;
            block0: for (Variant variant : VariantUtil.getVariants((Entity)this.self)) {
                VariantType variantType = VariantUtil.getType((Entity)this.self, variant);
                for (Action action : variantType.actions()) {
                    VariantActionType actionType = action.type();
                    actionType.initialize(action.arguments(), variant.arguments(), variantType.defaults());
                    if (!(actionType instanceof SetMooshroomMushroom)) continue;
                    SetMooshroomMushroom setMooshroomMushroom = (SetMooshroomMushroom)actionType;
                    mushroom = setMooshroomMushroom.mushroom;
                    continue block0;
                }
            }
            if (mushroom != null) {
                this.self.level().playSound(null, (Entity)this.self, SoundEvents.MOOSHROOM_SHEAR, category, 1.0f, 1.0f);
                if (!EventHooks.canLivingConvert((LivingEntity)this.self, (EntityType)EntityType.COW, timer -> {})) {
                    return;
                }
                Cow cow = (Cow)EntityType.COW.create(this.self.level());
                if (cow != null) {
                    EventHooks.onLivingConvert((LivingEntity)this.self, (LivingEntity)cow);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.self.getX(), this.self.getY(0.5), this.self.getZ(), 2, 0.0, 0.0, 0.0, 0.1);
                    this.self.discard();
                    cow.moveTo(this.self.getX(), this.self.getY(), this.self.getZ(), this.self.getYRot(), this.self.getXRot());
                    cow.setHealth(this.self.getHealth());
                    cow.yBodyRot = this.self.yBodyRot;
                    cow.setInvulnerable(this.self.isInvulnerable());
                    if (this.self.isPersistenceRequired()) {
                        cow.setPersistenceRequired();
                    }
                    cow.setCustomName(this.self.getCustomName());
                    cow.setCustomNameVisible(this.self.isCustomNameVisible());
                    this.self.level().addFreshEntity((Entity)cow);
                    for (int i = 0; i < this.self.getRandom().nextInt(3, 7); ++i) {
                        ItemEntity item = this.self.spawnAtLocation(new ItemStack((ItemLike)mushroom), this.self.getBbHeight());
                        if (item == null) continue;
                        item.setNoPickUpDelay();
                    }
                }
                ci.cancel();
            }
        }
    }
}

