/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.variants;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tazer.mixed_litter.Config;
import dev.tazer.mixed_litter.registry.MLDataAttachmentTypes;
import dev.tazer.mixed_litter.variants.ConfigCondition;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;

public record EntityConditions(Optional<ConfigCondition> configCondition, Optional<LocationPredicate> spawningLocation, Optional<EntityPredicate> predicate, boolean unobtainable) {
    public static final Codec<EntityConditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigCondition.CODEC.optionalFieldOf("remodel").forGetter(EntityConditions::configCondition), (App)LocationPredicate.CODEC.optionalFieldOf("spawning_location").forGetter(EntityConditions::spawningLocation), (App)EntityPredicate.CODEC.optionalFieldOf("entity_predicate").forGetter(EntityConditions::predicate), (App)Codec.BOOL.optionalFieldOf("unobtainable", (Object)false).forGetter(EntityConditions::unobtainable)).apply((Applicative)instance, EntityConditions::new));

    public boolean matches(ServerLevel level, @Nullable Vec3 position, Entity entity) {
        UnmodifiableConfig config;
        ModConfigSpec.BooleanValue booleanValue;
        if (this.unobtainable) {
            return false;
        }
        if (this.configCondition.isPresent() && ((Boolean)(booleanValue = (ModConfigSpec.BooleanValue)(config = (UnmodifiableConfig)Config.STARTUP_CONFIG.getValues().get("remodels")).get(this.configCondition.get().path() + "Remodel")).get()).booleanValue() != this.configCondition.get().status()) {
            return false;
        }
        if (entity.hasData(MLDataAttachmentTypes.SPAWN_LOCATION) && this.spawningLocation.isPresent()) {
            GlobalPos globalPos = (GlobalPos)entity.getData(MLDataAttachmentTypes.SPAWN_LOCATION);
            BlockPos pos = globalPos.pos();
            ServerLevel dimensionLevel = level.getServer().getLevel(globalPos.dimension());
            if (dimensionLevel == null || !this.spawningLocation.get().matches(dimensionLevel, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) {
                return false;
            }
        }
        return this.predicate.map(entityPredicate -> entityPredicate.matches(level, position, entity)).orElse(true);
    }
}

