package com.mynamesraph.sol.registry

import com.mynamesraph.sol.Constants
import com.mynamesraph.sol.SOLNeo
import com.mynamesraph.sol.registry.data.item.SOLSimpleItem
import net.minecraft.core.registries.Registries
import net.minecraft.resources.ResourceKey
import net.minecraft.resources.ResourceLocation
import net.minecraft.world.item.Item
import net.minecraft.world.item.ToolMaterial
import net.neoforged.bus.api.IEventBus
import net.neoforged.neoforge.registries.DeferredItem
import net.neoforged.neoforge.registries.DeferredRegister
import java.util.function.Supplier

object NeoItems {
    val ITEMS: DeferredRegister.Items = DeferredRegister.createItems(
        Constants.MOD_ID
    )

    val map = enumValues<SOLItems>().associateWith { ITEMS.register(
        it.item.name,
        Supplier {
            val resourceKey = ResourceKey.create(
                Registries.ITEM,
                ResourceLocation.fromNamespaceAndPath(
                    Constants.MOD_ID,
                    it.item.name
                )
            )
            return@Supplier when (val solItem = it.item) {
                is SOLSimpleItem -> {
                    solItem.factory(
                        solItem.properties.get().setId(resourceKey)
                    )
                }
                else -> {
                    throw UnsupportedOperationException("Item with factory of ${solItem.factory} cannot be registered!")
                }
            }
        }
    ) }


    fun register(eventBus: IEventBus) {
        ITEMS.register(eventBus)
    }
}


