package com.mynamesraph.sol.registry

import com.mojang.serialization.MapCodec
import com.mynamesraph.sol.Constants
import net.neoforged.bus.api.IEventBus
import net.neoforged.neoforge.common.loot.IGlobalLootModifier
import net.neoforged.neoforge.registries.DeferredRegister
import net.neoforged.neoforge.registries.NeoForgeRegistries
import java.util.function.Supplier

object NeoLootModifiers {
    val GLOBAL_LOOT_MODIFIER_SERIALIZERS: DeferredRegister<MapCodec<out IGlobalLootModifier>> = DeferredRegister.create(
        NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS,
        Constants.MOD_ID
    )

    val OAK_LEAVES = GLOBAL_LOOT_MODIFIER_SERIALIZERS.register("oak_leaves", Supplier{SOLLootModifier.CODEC})

    fun register(eventBus: IEventBus) {
        GLOBAL_LOOT_MODIFIER_SERIALIZERS.register(eventBus)
    }
}