package com.mynamesraph.sol.registry

import com.mynamesraph.sol.registry.data.item.ISOLItem
import com.mynamesraph.sol.registry.data.item.SOLSimpleItem
import net.minecraft.tags.BlockTags
import net.minecraft.tags.ItemTags
import net.minecraft.world.item.Item
import net.minecraft.world.item.ToolMaterial
import java.util.function.Supplier

val OAK = ToolMaterial(BlockTags.INCORRECT_FOR_WOODEN_TOOL,128, 0.0f,-1.0f,64, ItemTags.OAK_LOGS)
val BIRCH = ToolMaterial(BlockTags.INCORRECT_FOR_WOODEN_TOOL,128, 0.0f,-1.0f,64, ItemTags.BIRCH_LOGS)
val SPRUCE = ToolMaterial(BlockTags.INCORRECT_FOR_WOODEN_TOOL,128,0.0f,-1.0f,64, ItemTags.SPRUCE_LOGS)
val JUNGLE = ToolMaterial(BlockTags.INCORRECT_FOR_WOODEN_TOOL,128,0.0f,-1.0f,64, ItemTags.JUNGLE_LOGS)

enum class SOLItems(val item: ISOLItem) {
    OAK_LEGENDARY_SWORD(
        SOLSimpleItem(
            "oak_legendary_sword",
            {
                Item.Properties().sword(OAK,6.0f,-2.4f)
            }
        )
    ),
    BIRCH_LEGENDARY_SWORD(
        SOLSimpleItem(
            "birch_legendary_sword",
            {
                Item.Properties().sword(BIRCH,4.5f,-1.4f)
            }
        )
    ),
    SPRUCE_LEGENDARY_SWORD(
        SOLSimpleItem(
            "spruce_legendary_sword",
            {
                Item.Properties().sword(SPRUCE,6.5f,-2.5f)
            }
        )
    ),
    JUNGLE_LEGENDARY_SWORD(
        SOLSimpleItem(
            "jungle_legendary_sword",
            {
                Item.Properties().sword(JUNGLE, 20.0f,-3.9f)
            }
        )
    )

}