package com.mynamesraph.sol.registry

import com.mojang.serialization.MapCodec
import com.mojang.serialization.codecs.RecordCodecBuilder
import it.unimi.dsi.fastutil.objects.ObjectArrayList
import net.minecraft.core.registries.BuiltInRegistries
import net.minecraft.world.item.Item
import net.minecraft.world.item.ItemStack
import net.minecraft.world.level.storage.loot.LootContext
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition
import net.neoforged.neoforge.common.loot.IGlobalLootModifier
import net.neoforged.neoforge.common.loot.LootModifier

class SOLLootModifier(conditionsIn: Array<LootItemCondition>,val drop: Item) : LootModifier(conditionsIn) {

    companion object {
        val CODEC: MapCodec<SOLLootModifier> =
            RecordCodecBuilder.mapCodec {
                codecStart(it).and(
                    BuiltInRegistries.ITEM.byNameCodec().fieldOf("drop").forGetter(SOLLootModifier::drop)
                ).apply(it, ::SOLLootModifier)
            }
    }

    override fun doApply(
        generatedLoot: ObjectArrayList<ItemStack>,
        context: LootContext
    ): ObjectArrayList<ItemStack> {
        generatedLoot.add(drop.defaultInstance)
        return generatedLoot
    }

    override fun codec(): MapCodec<out IGlobalLootModifier?> {
        return CODEC
    }


}
