/*
 * Decompiled with CFR 0.152.
 */
package com.foxyjr.dpdownloader.gui;

import com.foxyjr.dpdownloader.Mod;
import com.foxyjr.dpdownloader.gui.DatapackInfo;
import com.foxyjr.dpdownloader.gui.DatapackInfoListWidget;
import com.foxyjr.dpdownloader.gui.DatapackListWidget;
import com.foxyjr.dpdownloader.gui.DatapackWorldListWidget;
import com.foxyjr.dpdownloader.gui.FileInfo;
import com.foxyjr.dpdownloader.gui.ResultInfo;
import com.foxyjr.dpdownloader.gui.VersionInfo;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.io.FileUtils;

public class InstallDatapackScreen
extends class_437 {
    public int totalResult = 0;
    private class_342 searchDatapacksField;
    private class_342 searchWorldsField;
    private class_4185 searchButton;
    private class_4185 moreButton;
    private class_4185 backButton;
    private final class_437 parent;
    public DatapackWorldListWidget worldList;
    public DatapackListWidget datapackList;
    public DatapackInfoListWidget datapackInfoList;
    private String oldSelectedWorld;
    private String tempPath = "";
    private JsonObject datapackDownloaderData = new JsonObject();

    public InstallDatapackScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"datapackdownloader.title"));
        this.parent = parent;
    }

    public InstallDatapackScreen(class_437 parent, String tempPath) {
        super((class_2561)class_2561.method_43471((String)"datapackdownloader.title"));
        this.parent = parent;
        this.tempPath = tempPath;
    }

    public void method_25410(class_310 client, int width, int height) {
        String oldSearchDatapacksField = this.searchDatapacksField.method_1882();
        String oldSearchWorldsField = this.searchWorldsField.method_1882();
        List<DatapackInfo> oldDatapackInfo = this.datapackList.getDatapacks();
        this.method_25423(client, width, height);
        this.searchDatapacksField.method_1852(oldSearchDatapacksField);
        this.searchWorldsField.method_1852(oldSearchWorldsField);
        this.datapackList.setDatapacks(oldDatapackInfo);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        this.searchDatapacksField = new class_342(this.field_22793, 165, 38, this.field_22789 - 56 - 137 - 56, 20, (class_2561)class_2561.method_43471((String)"datapackdownloader.field.search.datapack"));
        this.searchWorldsField = new class_342(this.field_22793, 28, 38, 132, 20, (class_2561)class_2561.method_43471((String)"datapackdownloader.field.search.world"));
        this.searchWorldsField.method_1863(search -> this.worldList.setSearch((String)search));
        this.searchButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"datapackdownloader.button.search"), button -> this.datapackList.updateDatapacks(this.fetchProjects(0), true)).method_46434(165 + (this.field_22789 - 56 - 137) - 50, 36, 50, 24).method_46431();
        this.moreButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"datapackdownloader.button.results"), button -> this.datapackList.updateDatapacks(this.fetchProjects(100 * this.datapackList.moreIndex), false)).method_46434(28, this.field_22790 - 30, 100, 24).method_46431();
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"datapackdownloader.button.back"), button -> this.method_25419()).method_46434(this.field_22789 - 60, this.field_22790 - 28, 50, 20).method_46431();
        this.worldList = new DatapackWorldListWidget(this, this.field_22787, this.tempPath);
        this.worldList.method_46421(28);
        this.datapackList = new DatapackListWidget(this, this.field_22787);
        this.datapackList.method_46421(165);
        this.datapackInfoList = new DatapackInfoListWidget(this, this.field_22787);
        this.datapackInfoList.method_46421(this.field_22789 / 2 + 160);
        this.method_25429((class_364)this.searchDatapacksField);
        this.method_25429((class_364)this.searchWorldsField);
        this.method_25429((class_364)this.searchButton);
        this.method_25429((class_364)this.worldList);
        this.method_25429((class_364)this.datapackList);
        this.method_25429((class_364)this.datapackInfoList);
        this.method_25429((class_364)this.moreButton);
        this.method_25429((class_364)this.backButton);
    }

    public ResultInfo fetchProjects(int offset) {
        HttpResponse<String> response;
        URI uri;
        if (this.field_22787 == null) {
            return new ResultInfo(List.of());
        }
        try {
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(() -> new RuntimeException("Failed to get minecraft mod info?"))).getMetadata().getVersion().getFriendlyString();
            String encodedQuery = URLEncoder.encode(this.searchDatapacksField.method_1882(), StandardCharsets.UTF_8);
            uri = new URI("https://api.modrinth.com/v2/search?query=" + encodedQuery + "&limit=100&offset=" + offset + "&facets=%5B%5B%22categories%3Adatapack%22%5D%2C%5B%22versions%3A" + version + "%22%5D%5D");
        }
        catch (URISyntaxException e) {
            Mod.LOGGER.error(e.getMessage());
            return new ResultInfo(List.of());
        }
        HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
        HttpClient client = HttpClient.newHttpClient();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            return new ResultInfo(List.of());
        }
        return (ResultInfo)new Gson().fromJson(response.body(), ResultInfo.class);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"datapackdownloader.label.search.datapacks"), 165, 26, -6250336);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"datapackdownloader.label.results", (Object[])new Object[]{this.totalResult}), this.field_22789 / 2, this.field_22790 - 25, -6250336);
        if (this.tempPath.isEmpty()) {
            this.searchWorldsField.method_25394(context, mouseX, mouseY, delta);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"datapackdownloader.label.search.worlds"), 28, 26, -6250336);
            this.worldList.method_25394(context, mouseX, mouseY, delta);
        } else {
            for (int i = 0; i < (this.field_22787 != null ? this.field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"datapackdownloader.download.warning"), 122).size() : 0); ++i) {
                context.method_35720(this.field_22787.field_1772, (class_5481)this.field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"datapackdownloader.download.warning"), 122).get(i), 28, 30 + 10 * i, -1);
            }
        }
        this.datapackList.method_25394(context, mouseX, mouseY, delta);
        if (this.field_22789 >= 800) {
            this.datapackInfoList.method_48579(context, mouseX, mouseY, delta);
        } else {
            this.datapackList.method_25358(this.field_22789 - 200);
        }
        this.searchButton.method_25394(context, mouseX, mouseY, delta);
        this.moreButton.method_25394(context, mouseX, mouseY, delta);
        this.backButton.method_25394(context, mouseX, mouseY, delta);
        this.searchDatapacksField.method_25394(context, mouseX, mouseY, delta);
        if (!Objects.equals(this.oldSelectedWorld, this.worldList.getSelected())) {
            this.oldSelectedWorld = this.worldList.getSelected();
            this.datapackList.updateDatapacks(this.fetchProjects(0), true);
        }
        if (this.datapackList.getSelectedOrNull() != null) {
            this.datapackInfoList.updateDatapack();
        }
    }

    public boolean method_25404(class_11908 keyInput) {
        if (this.field_22787 != null && keyInput.comp_4795() == 256) {
            this.field_22787.method_1507(this.parent);
            return true;
        }
        return super.method_25404(keyInput);
    }

    public void installDatapack(String slug, String latest_version) {
        HttpResponse<String> response;
        URI uri;
        if (this.field_22787 == null) {
            return;
        }
        try {
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(() -> new RuntimeException("Failed to get minecraft mod info?"))).getMetadata().getVersion().getFriendlyString();
            uri = new URI("https://api.modrinth.com/v2/project/" + slug + "/version?game_versions=%5B%22" + version + "%22%5D&loaders=%5B%22datapack%22%5D");
        }
        catch (URISyntaxException e) {
            Mod.LOGGER.error(e.getMessage());
            return;
        }
        HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
        HttpClient client = HttpClient.newHttpClient();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            return;
        }
        List<VersionInfo> versions = Arrays.stream((VersionInfo[])new Gson().fromJson(response.body(), VersionInfo[].class)).toList();
        if (versions.isEmpty()) {
            Mod.LOGGER.error("Something went wrong!");
            return;
        }
        VersionInfo version = versions.getFirst();
        for (FileInfo file : version.files) {
            String url = file.url;
            try {
                FileUtils.copyURLToFile((URL)new URI(url).toURL(), (File)new File(this.getDatapackPath(slug)));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
            this.writeJson(slug, latest_version);
        }
    }

    public boolean uninstallDatapack(String slug) {
        try {
            Files.deleteIfExists(new File(this.getDatapackPath(slug)).toPath());
            this.deleteJson(slug);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void updateDatapack(String slug, String latest_version) {
        this.uninstallDatapack(slug);
        this.installDatapack(slug, latest_version);
    }

    public void readJson() {
        try {
            FileReader file = new FileReader(this.getWorldPath() + "datapackdownloader.json");
            this.datapackDownloaderData = JsonParser.parseReader((Reader)file).getAsJsonObject();
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeJson(String slug, String version) {
        this.datapackDownloaderData.addProperty(slug, version);
        try {
            FileWriter file = new FileWriter(this.getWorldPath() + "datapackdownloader.json");
            file.write(String.valueOf(this.datapackDownloaderData));
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deleteJson(String slug) {
        this.datapackDownloaderData.remove(slug);
        try {
            FileWriter file = new FileWriter(this.getWorldPath() + "datapackdownloader.json");
            file.write(String.valueOf(this.datapackDownloaderData));
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isOutdated(String slug, String version) {
        if (this.datapackDownloaderData == null || this.datapackDownloaderData.get(slug) == null) {
            return false;
        }
        return !this.datapackDownloaderData.get(slug).getAsString().equals(version);
    }

    protected String getDatapackPath(String slug) {
        if (this.field_22787 == null || this.worldList.getSelected() == null && this.tempPath.isEmpty()) {
            return "";
        }
        if (!this.tempPath.isEmpty()) {
            return this.tempPath + "/" + slug + ".zip";
        }
        return this.getWorldPath() + slug + ".zip";
    }

    protected String getWorldPath() {
        if (this.field_22787 == null) {
            return "";
        }
        if (this.worldList.getSelected() == null) {
            return "";
        }
        if (this.worldList.getSelected().equals("Global Datapack (mod)")) {
            return String.valueOf(FabricLoader.getInstance().getGameDir().resolve("datapacks")) + "/";
        }
        return String.valueOf(this.field_22787.method_1586().method_19636().toAbsolutePath()) + "/" + this.worldList.getSelected() + "/datapacks/";
    }
}

