/*
 * Decompiled with CFR 0.152.
 */
package com.foxyjr.dpdownloader.gui;

import com.foxyjr.dpdownloader.Mod;
import com.foxyjr.dpdownloader.gui.InstallDatapackScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11909;
import net.minecraft.class_128;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_421;
import net.minecraft.class_4280;
import net.minecraft.class_437;

public class DatapackWorldListWidget
extends class_4280<WorldEntry> {
    final List<WorldEntry> worlds = new ArrayList<WorldEntry>();
    String search = "";
    String tempPath;

    public DatapackWorldListWidget(InstallDatapackScreen parent, class_310 client, String temp) {
        super(client, 132, 100, 70, 12);
        this.tempPath = temp;
        if (this.tempPath.isEmpty()) {
            this.loadLevels();
        }
    }

    private void loadLevels() {
        class_32.class_7410 levelList;
        try {
            levelList = this.field_22740.method_1586().method_235();
        }
        catch (class_33 levelStorageException) {
            Mod.LOGGER.error("Couldn't load level list", (Throwable)levelStorageException);
            this.showUnableToLoadScreen(levelStorageException.method_43416());
            return;
        }
        ((CompletableFuture)this.field_22740.method_1586().method_43417(levelList).exceptionally(throwable -> {
            this.field_22740.method_1494(class_128.method_560((Throwable)throwable, (String)"Couldn't load level list"));
            return List.of();
        })).whenComplete((levelSummaries, throwable) -> {
            levelSummaries.forEach(levelSummary -> this.worlds.add(new WorldEntry(this.field_22740, levelSummary.method_252())));
            this.showSummaries("", this.worlds);
        });
        if (FabricLoader.getInstance().isModLoaded("global-datapack")) {
            this.worlds.add(new WorldEntry(this.field_22740, "Global Datapack (mod)"));
        }
    }

    private void showUnableToLoadScreen(class_2561 message) {
        this.field_22740.method_1507((class_437)new class_421((class_2561)class_2561.method_43471((String)"selectWorld.unable_to_load"), message));
    }

    public void setSearch(String search) {
        if (!this.worlds.isEmpty()) {
            this.showSummaries(search, this.worlds);
        }
        this.search = search;
    }

    public void showSummaries(String search, List<WorldEntry> worldEntries) {
        this.method_25339();
        search = search.toLowerCase();
        for (WorldEntry worldEntry : worldEntries) {
            if (!this.shouldShow(search, worldEntry)) continue;
            this.method_25321((class_350.class_351)new WorldEntry(this.field_22740, worldEntry.worldName));
        }
    }

    private boolean shouldShow(String search, WorldEntry summary) {
        return summary.worldName.toLowerCase().contains(search.toLowerCase());
    }

    public int method_25322() {
        return this.field_22758;
    }

    protected int method_65507() {
        return this.method_55442() - 5;
    }

    public String getSelected() {
        WorldEntry selected = (WorldEntry)this.method_25334();
        if (selected == null) {
            return null;
        }
        return selected.worldName;
    }

    public class WorldEntry
    extends class_4280.class_4281<WorldEntry> {
        private final class_310 client;
        private final String worldName;

        public WorldEntry(class_310 client, String worldName) {
            this.client = client;
            this.worldName = worldName;
        }

        public class_2561 method_37006() {
            return class_2561.method_43471((String)"datapackdownloader.narration.world");
        }

        public boolean method_25406(class_11909 click) {
            DatapackWorldListWidget.this.method_25313((class_350.class_351)this);
            return true;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_25303(this.client.field_1772, this.worldName, this.method_46426(), this.method_46427(), -1);
        }
    }
}

