package com.mokkachocolata.minecraft.mod.luaruntime.client.mixin;

import com.mokkachocolata.minecraft.mod.luaruntime.Consts;
import com.mokkachocolata.minecraft.mod.luaruntime.client.LuaEvent;
import com.mokkachocolata.minecraft.mod.luaruntime.client.LuaRuntimeClient;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_7842;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Calls scripts when the player loads the main menu.
 *
 * @author Mokka Chocolata
 */
@Mixin(class_442.class)
public abstract class MainMenuMixin extends class_437 {
    protected MainMenuMixin(class_2561 title) {
        super(title);
    }

    // Courtesy of a bug report
    @Inject(at = @At("RETURN"), method = "init")
    private void versions(CallbackInfo ci) {
        LuaRuntimeClient.lua_runtime_mod$loaded = true;
        this.method_37063(new class_7842(0, 0, 90, 10, class_2561.method_30163("Lua Runtime " + Consts.Version), field_22793));
        this.method_37063(new class_7842(0, 10, 120, 10, class_2561.method_30163("Powered by LuaJ v3.0.1"), field_22793));
        lua_runtime_mod$callScriptsMenuListeners();
    }

    @Unique
    private void lua_runtime_mod$callScriptsMenuListeners()  {
        for (LuaEvent voids : LuaRuntimeClient.Instance.LuaInstance.getMainMenuListeners()) {
            voids.Call();
        }
    }
}
