/*
 * Decompiled with CFR 0.152.
 */
package com.mokkachocolata.minecraft.mod.luaruntime.client.lua.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mokkachocolata.minecraft.mod.luaruntime.Consts;
import com.mokkachocolata.minecraft.mod.luaruntime.client.Config;
import com.mokkachocolata.minecraft.mod.luaruntime.client.LuaEvent;
import com.mokkachocolata.minecraft.mod.luaruntime.client.LuaGUI;
import com.mokkachocolata.minecraft.mod.luaruntime.client.lua.api.gui.GUI;
import com.mokkachocolata.minecraft.mod.luaruntime.client.lua.api.gui.Keys;
import com.mokkachocolata.minecraft.mod.luaruntime.lua.api.Color3;
import com.mokkachocolata.minecraft.mod.luaruntime.lua.api.Property;
import com.yevdo.jwildcard.JWildcard;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_1041;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class Minecraft
extends TwoArgFunction {
    private final LuaValue functions = Minecraft.tableOf();
    private final Logger LOGGER;
    private final ArrayList<LuaGUI> guis;
    private final Config conf;
    private final boolean IsRunningOnPojavLauncher;
    private final ArrayList<LuaEvent> mainMenuListeners;

    public void AddToTable(LuaValue value) {
        this.functions.add(value);
    }

    public ArrayList<LuaEvent> getMainMenuListeners() {
        return this.mainMenuListeners;
    }

    private boolean CheckIfURLisBlocked(String url) {
        int n = 0;
        Config.URLConfig[] uRLConfigArray = this.conf.urls;
        int n2 = uRLConfigArray.length;
        if (n < n2) {
            Config.URLConfig urlConfig = uRLConfigArray[n];
            if (Objects.equals(urlConfig.url, "$local") && (JWildcard.matches((String)"*127.0.*.*", (String)url) || JWildcard.matches((String)"*192.168.*.*", (String)url) || JWildcard.matches((String)"*10.0.*.*", (String)url) || JWildcard.matches((String)"*0.0.*.*", (String)url)) && !urlConfig.allow) {
                return true;
            }
            return JWildcard.matches((String)("*" + urlConfig.url), (String)url) && !urlConfig.allow;
        }
        return false;
    }

    public LuaValue call(LuaValue arg1, LuaValue arg2) {
        OneArgFunction print = new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                Minecraft.this.LOGGER.info(arg.toString());
                return NONE;
            }
        };
        arg2.set("print", (LuaValue)print);
        this.functions.set("Print", (LuaValue)print);
        arg2.set("Color3", Color3.getLuaTableStatic());
        this.functions.set("GetWindowScale", (LuaValue)new VarArgFunction(this){

            public Varargs invoke(Varargs args) {
                class_1041 window = class_310.method_1551().method_22683();
                return 2.varargsOf((LuaValue)LuaValue.valueOf((int)window.method_4486()), (Varargs)LuaValue.valueOf((int)window.method_4502()));
            }
        });
        arg2.set("waitAsync", (LuaValue)new TwoArgFunction(this){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                new Thread(() -> {
                    try {
                        Thread.sleep(arg2.checklong());
                        arg1.checkfunction().call();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }).start();
                return NONE;
            }
        });
        LuaTable config = Minecraft.tableOf();
        config.set("GetFOV", (LuaValue)new ZeroArgFunction(this){

            public LuaValue call() {
                return 4.valueOf((int)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()));
            }
        });
        this.functions.set("Platform", System.getProperty("os.name"));
        this.functions.set("Version", class_155.method_16673().method_48019());
        this.functions.set("Loader", "Fabric");
        this.functions.set("LuaRuntimeVersion", Consts.Version);
        this.functions.set("ClientOrServer", "Client");
        LuaValue table = this.getKeyTable();
        this.functions.set("Keybinds", table);
        this.functions.set("Paste", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                if (!Minecraft.this.conf.allowPaste) {
                    throw new LuaError("Getting text from clipboard is not allowed by config");
                }
                try {
                    String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    return 5.valueOf((String)data);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.functions.set("Copy", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                if (!Minecraft.this.conf.allowCopy) {
                    throw new LuaError("Copying strings are not allowed by config");
                }
                class_310.method_1551().field_1774.method_1455(arg.toString());
                return NONE;
            }
        });
        this.functions.set("OpenLink", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue arg, LuaValue arg2) {
                if (!Minecraft.this.conf.allowOpenLinks) {
                    throw new LuaError("Opening links are not allowed by config");
                }
                class_407.method_49623(arg2.isnil() ? null : (class_437)Minecraft.this.guis.get(arg2.getmetatable().get("__index").checkint()), (String)arg.toString());
                return NONE;
            }
        });
        LuaTable plrTable = Minecraft.tableOf();
        plrTable.set("Username", (LuaValue)Minecraft.valueOf((String)class_310.method_1551().method_1548().method_1676()));
        plrTable.set("GetPos", (LuaValue)new VarArgFunction(this){

            public Varargs invoke(Varargs v) {
                assert (class_310.method_1551().field_1724 != null);
                class_243 position = class_310.method_1551().field_1724.method_19538();
                return 8.varargsOf((LuaValue[])new LuaValue[]{LuaValue.valueOf((double)position.field_1352), LuaValue.valueOf((double)position.field_1351), LuaValue.valueOf((double)position.field_1350)});
            }
        });
        plrTable.set("GetRot", (LuaValue)new VarArgFunction(this){

            public Varargs invoke(Varargs v) {
                assert (class_310.method_1551().field_1724 != null);
                class_746 player = class_310.method_1551().field_1724;
                class_241 rotation = new class_241(player.method_36455(), player.method_36454());
                return 9.varargsOf((LuaValue[])new LuaValue[]{LuaValue.valueOf((double)rotation.field_1343), LuaValue.valueOf((double)rotation.field_1342)});
            }
        });
        plrTable.set("GetDimension", (LuaValue)new ZeroArgFunction(this){

            public LuaValue call() {
                assert (class_310.method_1551().field_1687 != null);
                return 10.valueOf((String)class_310.method_1551().field_1687.method_40134().method_55840());
            }
        });
        this.functions.set("Player", (LuaValue)plrTable);
        LuaTable httpTable = Minecraft.tableOf();
        httpTable.set("Get", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                if (Minecraft.this.CheckIfURLisBlocked(arg1.toString())) {
                    throw new LuaError("URL blocked by config");
                }
                StringBuilder result = new StringBuilder();
                try {
                    String line;
                    URL url = new URI(arg1.toString()).toURL();
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                    return LuaValue.valueOf((String)result.toString());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        httpTable.set("Post", (LuaValue)new ThreeArgFunction(){

            public LuaValue call(LuaValue url, LuaValue args, LuaValue contentType) {
                if (Minecraft.this.CheckIfURLisBlocked(url.toString())) {
                    throw new LuaError("URL blocked by config");
                }
                HashMap<String, String> arguments = new HashMap<String, String>();
                for (int i = 0; i < args.checktable().length(); ++i) {
                    args.get(i).checktable();
                    arguments.put(args.get(i).get("name").toString(), args.get(i).get("value").toString());
                }
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    URLConnection con = new URI(url.toString()).toURL().openConnection();
                    HttpURLConnection urlConnection = (HttpURLConnection)con;
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setDoOutput(true);
                    StringJoiner sj = new StringJoiner("&");
                    for (Map.Entry entry : arguments.entrySet()) {
                        sj.add(URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8));
                    }
                    byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                    int len = out.length;
                    urlConnection.setFixedLengthStreamingMode(len);
                    urlConnection.setRequestProperty("Content-Type", contentType.toString());
                    urlConnection.connect();
                    OutputStream os = urlConnection.getOutputStream();
                    os.write(out);
                    os.flush();
                    os.close();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return LuaValue.valueOf((String)sb.toString());
            }
        });
        this.functions.set("Http", (LuaValue)httpTable);
        this.functions.set("AddCommand", (LuaValue)new TwoArgFunction(this){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                Object obj = new Object(this){
                    CommandContext<FabricClientCommandSource> Context;
                };
                ClientCommandRegistrationCallback.EVENT.register((arg_0, arg_1) -> this.lambda$call$1(arg1, obj, arg2, arg_0, arg_1));
                LuaTable table = 13.tableOf();
                table.set("SendFeedback", (LuaValue)new OneArgFunction(this, obj){
                    final /* synthetic */ 1 val$obj;
                    {
                        this.val$obj = var2_2;
                    }

                    public LuaValue call(LuaValue arg1) {
                        ((FabricClientCommandSource)this.val$obj.Context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)arg1.toString()));
                        return NONE;
                    }
                });
                return table;
            }

            private /* synthetic */ void lambda$call$1(LuaValue arg1, final 1 obj, LuaValue arg2, CommandDispatcher dispatcher, class_7157 registryAccess) {
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)arg1.toString()).executes(context -> {
                    obj.Context = context;
                    LuaTable table = 13.tableOf();
                    table.set("SendFeedback", (LuaValue)new OneArgFunction(this){

                        public LuaValue call(LuaValue arg) {
                            ((FabricClientCommandSource)obj.Context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)arg.toString()));
                            return NONE;
                        }
                    });
                    arg2.checkfunction().call((LuaValue)table);
                    return 1;
                }));
            }
        });
        LuaTable table2 = Minecraft.tableOf();
        table2.set("ChatEnabled", (LuaValue)LuaValue.valueOf((boolean)this.conf.allowChat));
        table2.set("CommandsEnabled", (LuaValue)LuaValue.valueOf((boolean)this.conf.allowCommands));
        LuaTable blockedTables = Minecraft.tableOf();
        for (int i = 0; i < this.conf.urls.length; ++i) {
            LuaTable blockUrlTable = Minecraft.tableOf();
            blockUrlTable.set("Allowed", (LuaValue)LuaValue.valueOf((boolean)this.conf.urls[i].allow));
            blockUrlTable.set("URL", (LuaValue)LuaValue.valueOf((String)this.conf.urls[i].url));
            blockedTables.set(i, (LuaValue)blockUrlTable);
        }
        table2.set("BlockedUrls", (LuaValue)blockedTables);
        table2.set("CopyEnabled", (LuaValue)Minecraft.valueOf((boolean)this.conf.allowCopy));
        table2.set("PasteEnabled", (LuaValue)Minecraft.valueOf((boolean)this.conf.allowPaste));
        table2.set("OpenLinkEnabled", (LuaValue)Minecraft.valueOf((boolean)this.conf.allowOpenLinks));
        table2.set("ListenChatEnabled", (LuaValue)Minecraft.valueOf((boolean)this.conf.allowListenChat));
        table2.set("IsPojavLauncher", (LuaValue)Minecraft.valueOf((boolean)this.IsRunningOnPojavLauncher));
        this.functions.set("Config", (LuaValue)table2);
        this.functions.set("PlaySound", (LuaValue)new ThreeArgFunction(this){

            public LuaValue call(final LuaValue arg, LuaValue volume, LuaValue pitch) {
                if (pitch.isnil()) {
                    pitch = 14.valueOf((int)0);
                }
                if (volume.isnil()) {
                    volume = 14.valueOf((double)0.5);
                }
                final LuaValue finalVolume = volume;
                final LuaValue finalPitch = pitch;
                class_310.method_1551().method_1483().method_4873(new class_1113(){

                    public class_2960 method_4775() {
                        return class_2960.method_60654((String)arg.toString());
                    }

                    @Nullable
                    public class_1146 method_4783(class_1144 soundManager) {
                        return null;
                    }

                    public class_1111 method_4776() {
                        return null;
                    }

                    public class_3419 method_4774() {
                        return null;
                    }

                    public boolean method_4786() {
                        return false;
                    }

                    public boolean method_4787() {
                        return false;
                    }

                    public int method_4780() {
                        return 0;
                    }

                    public float method_4781() {
                        return finalVolume.checknumber().tofloat();
                    }

                    public float method_4782() {
                        return finalPitch.checknumber().tofloat();
                    }

                    public double method_4784() {
                        return 0.0;
                    }

                    public double method_4779() {
                        return 0.0;
                    }

                    public double method_4778() {
                        return 0.0;
                    }

                    public class_1113.class_1114 method_4777() {
                        return null;
                    }
                });
                return NONE;
            }
        });
        this.functions.set("RegisterKeybind", (LuaValue)new TwoArgFunction(this){

            public LuaValue call(LuaValue arg2, LuaValue arg3) {
                final class_304 bind = new class_304("com.mokkachocolata.minecraft.mod.luaruntime.keys." + String.valueOf(arg2), class_3675.class_307.field_1668, arg3.checkint(), "com.mokkachocolata.minecraft.mod.luaruntime.keys.category");
                KeyBindingHelper.registerKeyBinding((class_304)bind);
                LuaTable table = 15.tableOf();
                table.set("GetPressed", (LuaValue)new ZeroArgFunction(this){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)bind.method_1436());
                    }
                });
                return table;
            }
        });
        this.functions.set("ShutdownClient", (LuaValue)new ZeroArgFunction(this){

            public LuaValue call() {
                class_310.method_1551().close();
                return NONE;
            }
        });
        this.functions.set("AddChatListener", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                if (Minecraft.this.conf.allowListenChat) {
                    ServerMessageEvents.CHAT_MESSAGE.register((message, player, none) -> event.Call((LuaValue)17.valueOf((String)Objects.requireNonNull(message.method_46291().method_54160())), (LuaValue)17.valueOf((String)Objects.requireNonNull(player.method_5477().method_54160()))));
                }
                return event.GetTable();
            }
        });
        this.functions.set("DisplayToast", (LuaValue)new TwoArgFunction(this){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_30163((String)arg1.toString()), (class_2561)class_2561.method_30163((String)arg2.toString())));
                return NONE;
            }
        });
        this.functions.set("AddClientLoadedListener", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                Minecraft.this.mainMenuListeners.add(event);
                return event.GetTable();
            }
        });
        this.functions.set("CreateNewGUI", (LuaValue)new GUI(this.guis));
        this.functions.set("RunCommand", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                if (!Minecraft.this.conf.allowCommands) {
                    throw new LuaError("Commands are not allowed by config");
                }
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    class_2170 commandManager = Objects.requireNonNull(player.method_5682()).method_3734();
                    class_2168 commandSource = player.method_5682().method_3739();
                    commandManager.method_44252(commandSource, arg.toString());
                }
                return NONE;
            }
        });
        this.functions.set("SendMessage", (LuaValue)new TwoArgFunction(this){

            public LuaValue call(LuaValue arg, LuaValue arg2) {
                assert (class_310.method_1551().field_1724 != null);
                if (arg2.isnil()) {
                    arg2 = 21.valueOf((boolean)false);
                }
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)arg.toString()), arg2.toboolean());
                return NONE;
            }
        });
        this.functions.set("Chat", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                if (!Minecraft.this.conf.allowChat) {
                    throw new LuaError("Sending messages to other players are not allowed by config");
                }
                assert (class_310.method_1551().field_1724 != null);
                class_310.method_1551().field_1724.field_3944.method_45729(arg.toString());
                return NONE;
            }
        });
        this.functions.set("GetFPS", (LuaValue)new ZeroArgFunction(this){

            public LuaValue call() {
                return LuaValue.valueOf((int)class_310.method_1551().method_47599());
            }
        });
        LuaTable ticks = Minecraft.tableOf();
        LuaTable clientTicks = Minecraft.tableOf();
        OneArgFunction tick = new OneArgFunction(this){

            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                ClientTickEvents.START_CLIENT_TICK.register(client -> event.Call());
                return event.GetTable();
            }
        };
        clientTicks.set("Tick", (LuaValue)tick);
        clientTicks.set("Start", (LuaValue)tick);
        clientTicks.set("StartWorld", (LuaValue)new OneArgFunction(this){

            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                ClientTickEvents.START_WORLD_TICK.register(world -> event.Call());
                return event.GetTable();
            }
        });
        clientTicks.set("End", (LuaValue)new OneArgFunction(this){

            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                ClientTickEvents.END_CLIENT_TICK.register(client -> event.Call());
                return event.GetTable();
            }
        });
        clientTicks.set("EndWorld", (LuaValue)new OneArgFunction(this){

            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                ClientTickEvents.END_WORLD_TICK.register(world -> event.Call());
                return event.GetTable();
            }
        });
        ticks.set("Client", (LuaValue)clientTicks);
        this.functions.set("Ticks", (LuaValue)ticks);
        arg2.set("Minecraft", this.functions);
        return this.functions;
    }

    @NotNull
    private LuaValue getKeyTable() {
        LuaTable table = Minecraft.tableOf();
        LuaTable keyTable = Minecraft.tableOf();
        for (Property<Integer> key : Keys.keys) {
            keyTable.set(key.propertyName, ((Integer)key.propertyValue).intValue());
        }
        table.set("Key", (LuaValue)keyTable);
        return table;
    }

    public Minecraft(Config conf, Logger logger, ArrayList<LuaGUI> guis, boolean runningOnPojavLauncher, ArrayList<LuaEvent> mainMenuListeners, Globals g) {
        this.conf = conf;
        this.LOGGER = logger;
        this.guis = guis;
        this.IsRunningOnPojavLauncher = runningOnPojavLauncher;
        this.mainMenuListeners = mainMenuListeners;
    }
}

