/*
 * Decompiled with CFR 0.152.
 */
package com.mokkachocolata.minecraft.mod.luaruntime.server;

import com.mokkachocolata.minecraft.mod.luaruntime.LuaEvent;
import com.mokkachocolata.minecraft.mod.luaruntime.server.ConfigServer;
import com.yevdo.jwildcard.JWildcard;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainClassServer
implements DedicatedServerModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"luaruntimemod");
    public ConfigServer conf;
    public MainClassServer Instance;
    public Minecraft LuaInstance;

    private <T> T[] toArray(Collection collection, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(array);
    }

    public void onInitializeServer() {
        LOGGER.info("SpongePowered LUAU Subsystem Version=0.8.7 Source=file:/home/user/net.fabricmc/sponge-mixin/0.15.3+mixin.0.8.7/51ee0a44ab05f6fddd66b09e66b3a16904f9c55d/sponge-mixin-0.15.3+mixin.0.8.7.jar Service=Knot/Fabric Env=CLIENT                       Just kidding obviously");
        this.Instance = this;
        File scriptsFolder = new File(FabricLoader.getInstance().getGameDir().toFile(), "lua");
        File config = new File(FabricLoader.getInstance().getConfigDir().toFile(), "lua_runtime_config_server.json");
        if (!config.exists()) {
            try {
                this.conf = new ConfigServer(new ConfigServer.URLConfig[]{new ConfigServer.URLConfig(false, "$local")}, true);
                FileWriter writer = MainClassServer.createConfigFile(config);
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FileInputStream inputStream = new FileInputStream(config);
            String fileContents = IOUtils.toString((InputStream)inputStream);
            JSONObject configJSON = new JSONObject(fileContents);
            ArrayList<ConfigServer.URLConfig> urlConfigs = new ArrayList<ConfigServer.URLConfig>();
            JSONArray urls = configJSON.getJSONArray("urls");
            for (int i = 0; i < urls.length(); ++i) {
                JSONObject object = urls.getJSONObject(i);
                urlConfigs.add(new ConfigServer.URLConfig(object.getBoolean("allow"), object.getString("url")));
            }
            this.conf = new ConfigServer(this.toArray(urlConfigs, ConfigServer.URLConfig.class), configJSON.getBoolean("allowListenChat"));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred trying to read the config file!");
            throw new RuntimeException(e);
        }
        if (!scriptsFolder.exists()) {
            scriptsFolder.mkdir();
        }
        Globals g = JsePlatform.standardGlobals();
        g.set("luajava", LuaValue.NIL);
        this.LuaInstance = new Minecraft();
        g.load((LuaValue)this.LuaInstance);
        for (File child : Objects.requireNonNull(scriptsFolder.listFiles())) {
            try {
                if (!FilenameUtils.getExtension((String)child.toPath().toString()).equals("lua")) continue;
                String contents = Files.readString(child.toPath());
                LOGGER.info("Loading {}", (Object)child.getName());
                try {
                    g.load(contents).call();
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while executing {}!", (Object)child.getName());
                    LOGGER.error(e.getMessage());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private static FileWriter createConfigFile(File config) throws IOException {
        config.createNewFile();
        JSONObject configJSON = new JSONObject();
        JSONArray urls = new JSONArray();
        JSONObject local = new JSONObject();
        local.put("url", (Object)"$local");
        local.put("allow", false);
        urls.put((Object)local);
        configJSON.put("urls", (Object)urls);
        configJSON.put("allowListenChat", false);
        FileWriter writer = new FileWriter(config);
        writer.write(configJSON.toString(4));
        return writer;
    }

    public class Minecraft
    extends TwoArgFunction {
        private final LuaValue functions = Minecraft.tableOf();

        public void AddToTable(LuaValue value) {
            this.functions.add(value);
        }

        private boolean CheckIfURLisBlocked(String url) {
            int n = 0;
            ConfigServer.URLConfig[] uRLConfigArray = MainClassServer.this.conf.urls;
            int n2 = uRLConfigArray.length;
            if (n < n2) {
                ConfigServer.URLConfig urlConfig = uRLConfigArray[n];
                if (Objects.equals(urlConfig.url, "$local") && (JWildcard.matches((String)"*127.0.*.*", (String)url) || JWildcard.matches((String)"*192.168.*.*", (String)url) || JWildcard.matches((String)"*10.0.*.*", (String)url) || JWildcard.matches((String)"*0.0.*.*", (String)url)) && !urlConfig.allow) {
                    return true;
                }
                return JWildcard.matches((String)("*" + urlConfig.url), (String)url) && !urlConfig.allow;
            }
            return false;
        }

        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            arg2.set("print", (LuaValue)new OneArgFunction(this){

                public LuaValue call(LuaValue arg) {
                    LOGGER.info(arg.toString());
                    return NIL;
                }
            });
            this.functions.set("Print", (LuaValue)new OneArgFunction(this){

                public LuaValue call(LuaValue arg) {
                    LOGGER.info(arg.toString());
                    return NONE;
                }
            });
            this.functions.set("Platform", System.getProperty("os.name"));
            this.functions.set("Version", class_155.method_16673().method_48019());
            this.functions.set("Loader", "Fabric");
            this.functions.set("LuaRuntimeVersion", 0.8);
            this.functions.set("ClientOrServer", "Server");
            LuaTable httpTable = Minecraft.tableOf();
            httpTable.set("Get", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg1) {
                    if (Minecraft.this.CheckIfURLisBlocked(arg1.toString())) {
                        throw new LuaError("URL blocked by config");
                    }
                    StringBuilder result = new StringBuilder();
                    try {
                        String line;
                        URL url = new URI(arg1.toString()).toURL();
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("GET");
                        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            result.append(line);
                        }
                        return LuaValue.valueOf((String)result.toString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            httpTable.set("Post", (LuaValue)new ThreeArgFunction(){

                public LuaValue call(LuaValue url, LuaValue args, LuaValue contentType) {
                    if (Minecraft.this.CheckIfURLisBlocked(url.toString())) {
                        throw new LuaError("URL blocked by config");
                    }
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    for (int i = 0; i < args.checktable().length(); ++i) {
                        args.get(i).checktable();
                        arguments.put(args.get(i).get("name").toString(), args.get(i).get("value").toString());
                    }
                    StringBuilder sb = new StringBuilder();
                    try {
                        String line;
                        URLConnection con = new URI(url.toString()).toURL().openConnection();
                        HttpURLConnection urlConnection = (HttpURLConnection)con;
                        urlConnection.setRequestMethod("POST");
                        urlConnection.setDoOutput(true);
                        StringJoiner sj = new StringJoiner("&");
                        for (Map.Entry entry : arguments.entrySet()) {
                            sj.add(URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8));
                        }
                        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
                        int len = out.length;
                        urlConnection.setFixedLengthStreamingMode(len);
                        urlConnection.setRequestProperty("Content-Type", contentType.toString());
                        urlConnection.connect();
                        OutputStream os = urlConnection.getOutputStream();
                        os.write(out);
                        os.flush();
                        os.close();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return LuaValue.valueOf((String)sb.toString());
                }
            });
            this.functions.set("Http", (LuaValue)httpTable);
            LuaTable table = Minecraft.tableOf();
            LuaTable blockedTables = Minecraft.tableOf();
            for (int i = 0; i < MainClassServer.this.conf.urls.length; ++i) {
                LuaTable blockUrlTable = Minecraft.tableOf();
                blockUrlTable.set("Allowed", (LuaValue)LuaValue.valueOf((boolean)MainClassServer.this.conf.urls[i].allow));
                blockUrlTable.set("URL", (LuaValue)LuaValue.valueOf((String)MainClassServer.this.conf.urls[i].url));
                blockedTables.set(i, (LuaValue)blockUrlTable);
            }
            table.set("BlockedUrls", (LuaValue)blockedTables);
            table.set("ListenChatEnabled", (LuaValue)Minecraft.valueOf((boolean)MainClassServer.this.conf.allowListenLinks));
            this.functions.set("Config", (LuaValue)table);
            this.functions.set("AddChatListener", (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    LuaEvent event = new LuaEvent(arg.checkfunction());
                    if (MainClassServer.this.conf.allowListenLinks) {
                        ServerMessageEvents.CHAT_MESSAGE.register((message, player, none) -> event.Call((LuaValue)5.valueOf((String)Objects.requireNonNull(message.method_46291().method_54160())), (LuaValue)5.valueOf((String)Objects.requireNonNull(player.method_5477().method_54160()))));
                    }
                    return event.GetTable();
                }
            });
            LuaTable ticks = Minecraft.tableOf();
            LuaTable clientTicks = Minecraft.tableOf();
            OneArgFunction forTicks = new OneArgFunction(this){

                public LuaValue call(LuaValue arg) {
                    LuaEvent event = new LuaEvent(arg.checkfunction());
                    ServerTickEvents.START_SERVER_TICK.register(client -> event.Call());
                    return event.GetTable();
                }
            };
            clientTicks.set("ForTicks", (LuaValue)forTicks);
            clientTicks.set("Start", (LuaValue)forTicks);
            clientTicks.set("StartWorld", (LuaValue)new OneArgFunction(this){

                public LuaValue call(LuaValue arg) {
                    LuaEvent event = new LuaEvent(arg.checkfunction());
                    ServerTickEvents.START_WORLD_TICK.register(world -> event.Call());
                    return event.GetTable();
                }
            });
            clientTicks.set("End", (LuaValue)new OneArgFunction(this){

                public LuaValue call(LuaValue arg) {
                    LuaEvent event = new LuaEvent(arg.checkfunction());
                    ServerTickEvents.END_SERVER_TICK.register(client -> event.Call());
                    return event.GetTable();
                }
            });
            clientTicks.set("EndWorld", (LuaValue)new OneArgFunction(this){

                public LuaValue call(LuaValue arg) {
                    LuaEvent event = new LuaEvent(arg.checkfunction());
                    ServerTickEvents.END_WORLD_TICK.register(world -> event.Call());
                    return event.GetTable();
                }
            });
            ticks.set("Server", (LuaValue)clientTicks);
            this.functions.set("Ticks", (LuaValue)ticks);
            arg2.set("Minecraft", this.functions);
            return this.functions;
        }
    }
}

