package com.mokkachocolata.minecraft.mod.luaruntime.client.lua.api.gui;

import com.mokkachocolata.minecraft.mod.luaruntime.LuaEvent;
import com.mokkachocolata.minecraft.mod.luaruntime.client.LuaGUI;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

public class GUI extends OneArgFunction {
    private final ArrayList<LuaGUI> guis;

    public GUI(ArrayList<LuaGUI> guis) {
        this.guis = guis;
    }
    @Override
    public LuaValue call(LuaValue arg) {
        LuaValue table = tableOf();
        LuaGUI thisGui = new LuaGUI(class_2561.method_43470(arg.toString()));
        LuaTable metaTable = tableOf();
        guis.add(thisGui);
        metaTable.set("__index", guis.size());
        table.setmetatable(metaTable);
        table.set("SetParent", new OneArgFunction() {
            @Override
            public LuaValue call(LuaValue arg) {
                if (!arg.istable() || arg.getmetatable().get("__index").isnil()) throw new LuaError("Not a GUI");
                thisGui.parent = guis.get(arg.getmetatable().get("__index").toint());
                return NONE;
            }
        });
        table.set("SetCancelable", new OneArgFunction() {
            @Override
            public LuaValue call(LuaValue arg) {
                thisGui.Cancelable = arg.checkboolean();
                return NONE;
            }
        });
        table.set("AddCloseListener", new OneArgFunction() {
            @Override
            public LuaValue call(LuaValue arg) {
                LuaEvent event = new LuaEvent(arg.checkfunction());
                thisGui.CloseCallback.add(event);
                return event.GetTable();
            }
        });
        table.set("Close", new ZeroArgFunction() {
            @Override
            public LuaValue call() {
                thisGui.method_25419();
                return NONE;
            }
        });
        table.set("Display", new ZeroArgFunction() {
            @Override
            public LuaValue call() {
                class_310.method_1551().method_1507(thisGui);
                return NONE;
            }
        });
        table.set("NewButton", new TwoArgFunction() {
            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                LuaValue table = tableOf();
                class_4185.class_7840 button = class_4185.method_46430(class_2561.method_43470(arg1.toString()), p -> arg2.checkfunction().call());
                table.set("SetTooltip", new OneArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg) {
                        button.method_46436(class_7919.method_47407(class_2561.method_43470(arg.toString())));
                        return NONE;
                    }
                });
                table.set("SetPosition", new TwoArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        button.method_46433(arg1.toint(), arg2.toint());
                        return NONE;
                    }
                });
                table.set("SetSize", new TwoArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        button.method_46437(arg1.toint() / 2 - 205, arg2.toint());
                        return NONE;
                    }
                });
                table.set("AddDrawableChild", new ZeroArgFunction() {
                    @Override
                    public LuaValue call() {
                        class_4185 builded = button.method_46431();
                        int index = thisGui.clickableWidgets.size();
                        thisGui.addClickableDrawableChild(builded);
                        LuaValue meta = tableOf();
                        meta.set("Delete", new ZeroArgFunction() {
                            @Override
                            public LuaValue call() {
                                thisGui.clickableWidgets.remove(index);
                                return NONE;
                            }
                        });
                        meta.set("IsFocused", new ZeroArgFunction() {
                            @Override
                            public LuaValue call() {
                                return LuaValue.valueOf(builded.method_25370());
                            }
                        });
                        meta.set("SetText", new OneArgFunction() {
                            @Override
                            public LuaValue call(LuaValue arg) {
                                builded.method_25355(class_2561.method_43470(arg.toString()));
                                return NONE;
                            }
                        });
                        meta.set("SetTooltip", new OneArgFunction() {
                            @Override
                            public LuaValue call(LuaValue arg) {
                                builded.method_47400(class_7919.method_47407(class_2561.method_43470(arg.toString())));
                                return NONE;
                            }
                        });
                        meta.set("SetPosition", new TwoArgFunction() {
                            @Override
                            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                                builded.method_48229(arg1.toint(), arg2.toint());
                                return NONE;
                            }
                        });
                        meta.set("SetSize", new TwoArgFunction() {
                            @Override
                            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                                builded.method_55445(arg1.toint() / 2 - 205, arg2.toint());
                                return NONE;
                            }
                        });
                        return meta;
                    }
                });
                return table;
            }
        });
        table.set("NewText", new OneArgFunction() {
            @Override
            public LuaValue call(LuaValue arg1) {
                LuaValue table = tableOf();
                class_7842 button = new class_7842(class_2561.method_43470(arg1.toString()), class_310.method_1551().field_1772);
                table.set("SetText", new OneArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg) {
                        button.method_25355(class_2561.method_43470(arg.toString()));
                        return NONE;
                    }
                });
                table.set("SetPosition", new TwoArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        button.method_46421(arg1.toint());
                        button.method_46419(arg2.toint());
                        return NONE;
                    }
                });
                table.set("IsFocused", new ZeroArgFunction() {
                    @Override
                    public LuaValue call() {
                        return LuaValue.valueOf(button.method_25370());
                    }
                });
                table.set("SetSize", new TwoArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        button.method_25358(arg1.toint() / 2 - 205);
                        button.method_53533(arg2.toint());
                        return NONE;
                    }
                });
                table.set("AddDrawableChild", new ZeroArgFunction() {
                    @Override
                    public LuaValue call() {
                        int index = thisGui.clickableWidgets.size();
                        thisGui.addClickableDrawableChild(button);
                        LuaValue meta = tableOf();
                        meta.set("Delete", new ZeroArgFunction() {
                            @Override
                            public LuaValue call() {
                                thisGui.clickableWidgets.remove(index);
                                return NONE;
                            }
                        });
                        return meta;
                    }
                });
                return table;
            }
        });
        table.set("NewTextField", new TwoArgFunction() {
            @Override
            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                LuaValue table = tableOf();
                class_342 button = new class_342(class_310.method_1551().field_1772, arg1.toint(), arg2.toint(), class_2561.method_43473());
                table.set("SetPlaceholder", new OneArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg) {
                        button.method_47404(class_2561.method_43470(arg.toString()));
                        return NONE;
                    }
                });
                table.set("SetEditable", new OneArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg) {
                        button.method_1888(arg.checkboolean());
                        return NONE;
                    }
                });
                table.set("SetVisible", new OneArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg) {
                        button.method_1862(arg.checkboolean());
                        return NONE;
                    }
                });
                table.set("IsFocused", new ZeroArgFunction() {
                    @Override
                    public LuaValue call() {
                        return LuaValue.valueOf(button.method_25370());
                    }
                });
                table.set("SetPosition", new TwoArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        button.method_46421(arg1.toint());
                        button.method_46419(arg2.toint());
                        return NONE;
                    }
                });
                table.set("SetSize", new TwoArgFunction() {
                    @Override
                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        button.method_25358(arg1.toint() / 2 - 205);
                        button.method_53533(arg2.toint());
                        return NONE;
                    }
                });
                table.set("GetText", new ZeroArgFunction() {
                    @Override
                    public LuaValue call() {
                        return LuaValue.valueOf(button.method_1882());
                    }
                });
                table.set("AddDrawableChild", new ZeroArgFunction() {
                    @Override
                    public LuaValue call() {
                        int index = thisGui.clickableWidgets.size();
                        thisGui.addClickableDrawableChild(button);
                        LuaValue meta = tableOf();
                        meta.set("Delete", new ZeroArgFunction() {
                            @Override
                            public LuaValue call() {
                                thisGui.clickableWidgets.remove(index);
                                return NONE;
                            }
                        });
                        return meta;
                    }
                });
                return table;
            }
        });
        return table;
    }
}
