/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.nopacketban;

import io.github.lumine1909.nopacketban.handler.DecodeChecker;
import io.github.lumine1909.nopacketban.handler.EncodeChecker;
import io.github.lumine1909.nopacketban.handler.PrependChecker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.function.Function;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.injectPlayer(e.getPlayer());
    }

    private void injectPlayer(Player player) {
        Channel channel = ((CraftPlayer)player).getHandle().connection.connection.channel;
        this.addOutboundChecker(channel, "encoder", encoder -> new EncodeChecker(player, (PacketEncoder)encoder));
        this.addInboundChecker(channel, "decoder", decoder -> new DecodeChecker(player, (PacketDecoder)decoder));
        this.addOutboundChecker(channel, "prepender", prepender -> new PrependChecker(player));
    }

    private void addOutboundChecker(Channel channel, String id, Function<ChannelHandler, ChannelHandler> creator) {
        ChannelHandler handler = channel.pipeline().get(id);
        if (handler == null) {
            throw new RuntimeException("No handler found for id " + id);
        }
        channel.pipeline().addAfter(id, id + "_checker", creator.apply(handler));
    }

    private void addInboundChecker(Channel channel, String id, Function<ChannelHandler, ChannelHandler> creator) {
        ChannelHandler handler = channel.pipeline().get(id);
        if (handler == null) {
            throw new RuntimeException("No handler found for id " + id);
        }
        channel.pipeline().addBefore(id, id + "_checker", creator.apply(handler));
    }
}

