/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.nopacketban.handler;

import io.github.lumine1909.nopacketban.handler.SecurityChecker;
import io.github.lumine1909.nopacketban.util.Reflection;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.InvocationTargetException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;
import org.bukkit.entity.Player;

public class EncodeChecker<T extends PacketListener>
extends ChannelOutboundHandlerAdapter
implements SecurityChecker<Packet> {
    private final Player player;
    private final PacketEncoder<T> dummyEncoder;

    public EncodeChecker(Player player, PacketEncoder<T> encoder) {
        this.dummyEncoder = new PacketEncoder((ProtocolInfo)Reflection.encoderProtocolInfo.get(encoder));
        this.player = player;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Packet)) {
            super.write(ctx, msg, promise);
            return;
        }
        try {
            this.checkSecurity(ctx, (Packet)msg);
            super.write(ctx, msg, promise);
        }
        catch (Throwable t) {
            this.player.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)("Failed to encode packet " + msg.getClass().getSimpleName() + " ."), (TextColor)NamedTextColor.RED), Component.text((String)"Please report to server admin if you believe this is in error.", (TextColor)NamedTextColor.RED), Component.text((String)"Or consider you are being packet kicked.", (TextColor)NamedTextColor.RED), Component.text((String)("Details: " + t.getMessage()), (TextColor)NamedTextColor.RED)}));
        }
    }

    @Override
    public void checkSecurity(ChannelHandlerContext ctx, Packet msg) throws Throwable {
        ByteBuf buf = ctx.alloc().heapBuffer();
        try {
            Reflection.messageToByteEncode.invoke(this.dummyEncoder, ctx, msg, buf);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            buf.release();
        }
    }
}

