/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.nopacketban.handler;

import io.github.lumine1909.nopacketban.handler.SecurityChecker;
import io.github.lumine1909.nopacketban.util.Reflection;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.Varint21FrameDecoder;
import org.bukkit.entity.Player;

public class SplitChecker
extends ChannelInboundHandlerAdapter
implements SecurityChecker<ByteBuf> {
    private final Player player;
    private final Varint21FrameDecoder dummySplitter;

    public SplitChecker(Player player) {
        this.player = player;
        this.dummySplitter = new Varint21FrameDecoder((BandwidthDebugMonitor)new DummyMonitor());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            super.channelRead(ctx, msg);
            return;
        }
        try {
            this.checkSecurity(ctx, (ByteBuf)msg);
            super.channelRead(ctx, msg);
        }
        catch (Throwable t) {
            this.player.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Component.text((String)("Failed to split message " + msg.getClass().getSimpleName() + " ."), (TextColor)NamedTextColor.RED), Component.text((String)"Please report to server admin if you believe this is in error.", (TextColor)NamedTextColor.RED), Component.text((String)"Or consider you are sending a huge packet.", (TextColor)NamedTextColor.RED), Component.text((String)("Details: " + t.getMessage()), (TextColor)NamedTextColor.RED)}));
        }
    }

    @Override
    public void checkSecurity(ChannelHandlerContext ctx, ByteBuf msg) throws Throwable {
        ByteBuf buf = msg.retainedDuplicate();
        try {
            Reflection.byteToMessageDecode.invoke(this.dummySplitter, ctx, buf, new ArrayList());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            buf.release();
        }
    }

    static class DummyMonitor
    extends BandwidthDebugMonitor {
        public DummyMonitor() {
            super(null);
        }

        public void tick() {
        }

        public void onReceive(int amount) {
        }
    }
}

