/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker;

import com.mafuyu404.diligentstalker.component.StalkerDataComponents;
import com.mafuyu404.diligentstalker.data.StalkerDataAttachments;
import com.mafuyu404.diligentstalker.init.NetworkHandler;
import com.mafuyu404.diligentstalker.registry.Config;
import com.mafuyu404.diligentstalker.registry.StalkerBlockEntities;
import com.mafuyu404.diligentstalker.registry.StalkerBlocks;
import com.mafuyu404.diligentstalker.registry.StalkerCreativeModeTab;
import com.mafuyu404.diligentstalker.registry.StalkerEntities;
import com.mafuyu404.diligentstalker.registry.StalkerItems;
import com.mojang.logging.LogUtils;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import org.slf4j.Logger;

@Mod(value="diligentstalker")
public class DiligentStalker {
    public static final String MODID = "diligentstalker";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IS_DEVELOPMENT_ENV = !FMLLoader.isProduction();

    public static void debug(Object source, String msg, Object ... params) {
        if (IS_DEVELOPMENT_ENV) {
            String string;
            if (source instanceof Class) {
                Class c = (Class)source;
                string = c.getSimpleName();
            } else {
                string = source.getClass().getSimpleName();
            }
            String className = string;
            LOGGER.debug("[DEBUG][{}] {}", (Object)className, (Object)String.format(msg, params));
        }
    }

    public static void debug(Object source, String msg) {
        if (IS_DEVELOPMENT_ENV) {
            String string;
            if (source instanceof Class) {
                Class c = (Class)source;
                string = c.getSimpleName();
            } else {
                string = source.getClass().getSimpleName();
            }
            String className = string;
            LOGGER.debug("[DEBUG][{}] {}", (Object)className, (Object)msg);
        }
    }

    public DiligentStalker(IEventBus modEventBus, ModContainer modContainer) {
        DiligentStalker.registerConfig(modContainer);
        DiligentStalker.init(modEventBus);
    }

    private static void init(IEventBus eventBus) {
        StalkerEntities.ENTITIES.register(eventBus);
        StalkerBlocks.BLOCKS.register(eventBus);
        StalkerBlockEntities.BLOCK_ENTITIES.register(eventBus);
        StalkerItems.ITEMS.register(eventBus);
        StalkerCreativeModeTab.TABS.register(eventBus);
        StalkerDataAttachments.ATTACHMENT_TYPES.register(eventBus);
        StalkerDataComponents.DATA_COMPONENT_TYPES.register(eventBus);
        eventBus.addListener(NetworkHandler::register);
    }

    private static void registerConfig(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.init());
    }
}

