/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.block;

import com.mafuyu404.diligentstalker.entity.CameraStalkerBlockEntity;
import com.mafuyu404.diligentstalker.entity.CameraStalkerEntity;
import com.mafuyu404.diligentstalker.registry.StalkerEntities;
import com.mojang.serialization.MapCodec;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CameraStalkerBlock
extends BaseEntityBlock {
    public static final MapCodec<CameraStalkerBlock> CODEC = CameraStalkerBlock.simpleCodec(CameraStalkerBlock::new);

    public CameraStalkerBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_.strength(1.0f));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            CameraStalkerEntity entity = new CameraStalkerEntity(StalkerEntities.CAMERA_STALKER.get(), level);
            entity.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
            level.addFreshEntity((Entity)entity);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CameraStalkerBlockEntity) {
                CameraStalkerBlockEntity be = (CameraStalkerBlockEntity)blockEntity;
                be.setCameraStalkerUUID(entity.getUUID());
                be.setChanged();
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Entity entity;
        CameraStalkerBlockEntity be;
        UUID entityId;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CameraStalkerBlockEntity && (entityId = (be = (CameraStalkerBlockEntity)blockEntity).getCameraStalkerUUID()) != null && (entity = ((ServerLevel)level).getEntity(entityId)) != null) {
            entity.discard();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new CameraStalkerBlockEntity(p_153215_, p_153216_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.ATTACH_FACE});
    }
}

