/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.data;

import com.mafuyu404.diligentstalker.api.IControllableStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ControllableStorage
implements IControllableStorage,
INBTSerializable<CompoundTag> {
    private static final String FUEL_KEY = "ControllableFuel";
    private static final String MAX_FUEL_KEY = "ControllableMaxFuel";
    private static final String CAMERA_STATE_KEY = "CameraState";
    private static final String SIGNAL_RADIUS_KEY = "SignalRadius";
    private static final String ACTION_CONTROL_KEY = "ActionControl";
    public static final List<String> CAMERA_STATE_TYPE = List.of("free", "follow", "control");
    public static final Codec<ControllableStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fuel").forGetter(ControllableStorage::getFuel), (App)Codec.INT.fieldOf("maxFuel").forGetter(ControllableStorage::getMaxFuel), (App)Codec.STRING.fieldOf("cameraState").forGetter(ControllableStorage::getCameraState), (App)Codec.INT.fieldOf("signalRadius").forGetter(ControllableStorage::getSignalRadius), (App)Codec.BOOL.fieldOf("actionControl").forGetter(ControllableStorage::isActionControlling)).apply((Applicative)instance, ControllableStorage::new));
    public static final StreamCodec<FriendlyByteBuf, ControllableStorage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ControllableStorage::getFuel, (StreamCodec)ByteBufCodecs.INT, ControllableStorage::getMaxFuel, (StreamCodec)ByteBufCodecs.STRING_UTF8, ControllableStorage::getCameraState, (StreamCodec)ByteBufCodecs.INT, ControllableStorage::getSignalRadius, (StreamCodec)ByteBufCodecs.BOOL, ControllableStorage::isActionControlling, ControllableStorage::new);
    private int fuel = 0;
    private int maxFuel = 100;
    private String cameraState = CAMERA_STATE_TYPE.getFirst();
    private int signalRadius = 256;
    private boolean isActionControlling = true;

    public ControllableStorage() {
    }

    public ControllableStorage(int fuel, int maxFuel, String cameraState, int signalRadius, boolean isActionControlling) {
        this.fuel = fuel;
        this.maxFuel = maxFuel;
        this.cameraState = cameraState;
        this.signalRadius = signalRadius;
        this.isActionControlling = isActionControlling;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt(FUEL_KEY, this.fuel);
        tag.putInt(MAX_FUEL_KEY, this.maxFuel);
        tag.putString(CAMERA_STATE_KEY, this.cameraState);
        tag.putInt(SIGNAL_RADIUS_KEY, this.signalRadius);
        tag.putBoolean(ACTION_CONTROL_KEY, this.isActionControlling);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.fuel = tag.getInt(FUEL_KEY);
        this.maxFuel = tag.getInt(MAX_FUEL_KEY);
        this.cameraState = tag.getString(CAMERA_STATE_KEY);
        this.signalRadius = tag.getInt(SIGNAL_RADIUS_KEY);
        this.isActionControlling = tag.getBoolean(ACTION_CONTROL_KEY);
    }

    @Override
    public int getFuel() {
        return this.fuel;
    }

    @Override
    public void setFuel(int amount) {
        this.fuel = Mth.clamp((int)amount, (int)0, (int)this.maxFuel);
    }

    @Override
    public boolean consumeFuel(int amount) {
        if (this.fuel >= amount) {
            this.setFuel(this.fuel - amount);
            return true;
        }
        return false;
    }

    @Override
    public void setMaxFuel(int amount) {
        this.maxFuel = amount;
    }

    @Override
    public int getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public void setCameraState(String value) {
        if (!CAMERA_STATE_TYPE.contains(value)) {
            return;
        }
        this.cameraState = value;
    }

    @Override
    public String getCameraState() {
        return this.cameraState;
    }

    @Override
    public void switchCameraState() {
        int index = CAMERA_STATE_TYPE.indexOf(this.cameraState);
        int next = index + 1;
        if (next == CAMERA_STATE_TYPE.size()) {
            next = 0;
        }
        this.cameraState = CAMERA_STATE_TYPE.get(next);
    }

    @Override
    public int getSignalRadius() {
        return this.signalRadius;
    }

    @Override
    public void setSignalRadius(int value) {
        this.signalRadius = value;
    }

    @Override
    public boolean isActionControlling() {
        return this.isActionControlling;
    }

    @Override
    public void turnActionControlling() {
        this.isActionControlling = !this.isActionControlling;
    }
}

