/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.entity;

import com.mafuyu404.diligentstalker.api.IControllable;
import com.mafuyu404.diligentstalker.component.StalkerDataComponents;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.registry.StalkerItems;
import com.mafuyu404.diligentstalker.utils.ControllableUtils;
import com.mafuyu404.diligentstalker.utils.StalkerUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class DroneStalkerEntity
extends Boat
implements HasCustomInventoryScreen,
ContainerEntity,
IControllable {
    private static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;
    private static final int SIGNAL_RADIUS = 1024;
    private static final int MAX_FUEL = 100;
    private static final int MAX_FUEL_TICK = 720;
    private int fuel_tick = 720;
    private static final int ITEM_PICKUP_RANGE = 2;
    private int interact_cooldown = 0;

    public DroneStalkerEntity(EntityType<? extends Boat> p_219869_, Level level) {
        super(p_219869_, level);
        ControllableUtils.setMaxFuel((Entity)this, 100);
        ControllableUtils.setSignalRadius((Entity)this, 1024);
    }

    public DroneStalkerEntity(Level p_219872_, double p_219873_, double p_219874_, double p_219875_) {
        this((EntityType<? extends Boat>)EntityType.CHEST_BOAT, p_219872_);
        this.setPos(p_219873_, p_219874_, p_219875_);
        this.xo = p_219873_;
        this.yo = p_219874_;
        this.zo = p_219875_;
    }

    @Override
    public void pushAdditionalControl(CompoundTag input) {
    }

    @Override
    public Vec3 tickServerControl(CompoundTag input, Vec3 motion) {
        float forwardZ;
        float forwardX;
        double xz;
        float z;
        float x;
        float xRot = input.getFloat("xRot");
        float yRot = input.getFloat("yRot");
        float speed = 0.45f;
        Vec3 forward = Vec3.ZERO;
        Vec3 right = Vec3.ZERO;
        Vec3 top = Vec3.ZERO;
        Vec3 result = Vec3.ZERO;
        if (input.getBoolean("Up") || input.getBoolean("Down")) {
            x = 0.0f;
            z = 0.0f;
            Vec3 lookAngle = this.calculateViewVector(xRot, yRot);
            xz = Math.sqrt(lookAngle.x * lookAngle.x + lookAngle.z * lookAngle.z);
            forwardX = (float)(lookAngle.x / xz);
            forwardZ = (float)(lookAngle.z / xz);
            if (input.getBoolean("Up")) {
                x += forwardX * speed;
                z += forwardZ * speed;
            }
            if (input.getBoolean("Down")) {
                x -= forwardX * speed;
                z -= forwardZ * speed;
            }
            forward = StalkerUtil.limitSpeed(new Vec3((double)x, 0.0, (double)z), speed);
        }
        if (input.getBoolean("Left") || input.getBoolean("Right")) {
            x = 0.0f;
            z = 0.0f;
            Vec3 subAngle = StalkerUtil.calculateViewVector(xRot, yRot - 90.0f);
            xz = Math.sqrt(subAngle.x * subAngle.x + subAngle.z * subAngle.z);
            forwardX = (float)(subAngle.x / xz);
            forwardZ = (float)(subAngle.z / xz);
            if (input.getBoolean("Left")) {
                x += forwardX * speed;
                z += forwardZ * speed;
            }
            if (input.getBoolean("Right")) {
                x -= forwardX * speed;
                z -= forwardZ * speed;
            }
            right = StalkerUtil.limitSpeed(new Vec3((double)x, 0.0, (double)z), speed);
        }
        if (input.getBoolean("Jump") || input.getBoolean("Shift")) {
            float y = 0.0f;
            if (input.getBoolean("Jump")) {
                y = speed;
            }
            if (input.getBoolean("Shift")) {
                y = -speed;
            }
            top = StalkerUtil.limitSpeed(new Vec3(0.0, (double)y, 0.0), speed);
        }
        result = result.add(forward).add(right).add(top);
        result = new Vec3(Mth.lerp((double)0.3f, (double)motion.x, (double)(motion.x + result.x)), Mth.lerp((double)0.3f, (double)motion.y, (double)(motion.y + result.y)), Mth.lerp((double)0.3f, (double)motion.z, (double)(motion.z + result.z)));
        result = StalkerUtil.limitSpeed(new Vec3(result.x, 0.0, result.z), speed).add(StalkerUtil.limitSpeed(new Vec3(0.0, result.y, 0.0), speed));
        result = result.scale(0.8);
        return result;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.interact_cooldown > 0) {
            return InteractionResult.FAIL;
        }
        this.interact_cooldown = 20;
        if (player.isShiftKeyDown()) {
            ItemStack itemStack = player.getMainHandItem();
            if (itemStack.is(Items.SUGAR)) {
                if (!this.level().isClientSide) {
                    int needed = 100 - ControllableUtils.getFuel((Entity)this);
                    if (needed > 0) {
                        int toAdd = Math.min(itemStack.getCount(), needed);
                        ControllableUtils.setFuel((Entity)this, ControllableUtils.getFuel((Entity)this) + toAdd);
                        itemStack.shrink(toAdd);
                        player.displayClientMessage((Component)Component.translatable((String)"message.diligentstalker.fuel_added", (Object[])new Object[]{toAdd}).withStyle(ChatFormatting.GREEN), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.diligentstalker.fuel_full").withStyle(ChatFormatting.RED), true);
                    }
                }
                return InteractionResult.FAIL;
            }
            if (itemStack.is(StalkerItems.STALKER_MASTER)) {
                UUID stalkerId = (UUID)itemStack.get((DataComponentType)StalkerDataComponents.STALKER_ID.get());
                if (stalkerId == null || !stalkerId.equals(this.uuid)) {
                    itemStack.set((DataComponentType)StalkerDataComponents.STALKER_ID.get(), (Object)this.uuid);
                    player.displayClientMessage((Component)Component.translatable((String)"message.diligentstalker.record_success").withStyle(ChatFormatting.GREEN), true);
                }
            } else if (!this.level().isClientSide) {
                InteractionResult interactionresult = this.interactWithContainerVehicle(player);
                if (interactionresult.consumesAction()) {
                    this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
                }
                return interactionresult;
            }
        }
        return InteractionResult.FAIL;
    }

    public void tick() {
        if (this.interact_cooldown > 0) {
            --this.interact_cooldown;
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!Stalker.hasInstanceOf((Entity)this)) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        } else if (!this.level().isClientSide && this.getDeltaMovement().length() > 0.1) {
            if (this.fuel_tick <= 0) {
                ControllableUtils.consumeFuel((Entity)this, 1);
                this.fuel_tick = 720;
            } else {
                --this.fuel_tick;
            }
        }
        if (!this.level().isClientSide && this.tickCount % 10 == 0) {
            AABB area = this.getBoundingBox().inflate(2.0);
            List items = this.level().getEntitiesOfClass(ItemEntity.class, area, e -> e.isAlive() && !e.getItem().isEmpty());
            if (!items.isEmpty()) {
                for (ItemEntity item : items) {
                    ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)new InvWrapper((Container)this), (ItemStack)item.getItem(), (boolean)false);
                    if (remaining.isEmpty()) {
                        item.discard();
                        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                        continue;
                    }
                    if (remaining.getCount() >= item.getItem().getCount()) continue;
                    item.setItem(remaining);
                    this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)this);
                }
            }
        }
    }

    protected void checkFallDamage(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
            int fuel = ControllableUtils.getFuel((Entity)this);
            if (fuel > 0) {
                ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)Items.SUGAR, fuel));
                this.level().addFreshEntity((Entity)itementity);
            }
        }
        super.remove(reason);
    }

    protected float getSinglePassengerXOffset() {
        return 0.15f;
    }

    protected int getMaxPassengers() {
        return 0;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        RegistryAccess provider = this.level().registryAccess();
        this.addChestVehicleSaveData(tag, (HolderLookup.Provider)provider);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readChestVehicleSaveData(tag, (HolderLookup.Provider)this.level().registryAccess());
    }

    public void destroy(DamageSource p_219892_) {
        super.destroy(p_219892_);
        this.chestVehicleDestroyed(p_219892_, this.level(), (Entity)this);
    }

    public void openCustomInventoryScreen(Player p_219906_) {
        p_219906_.openMenu((MenuProvider)this);
        if (!p_219906_.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)p_219906_);
            PiglinAi.angerNearbyPiglins((Player)p_219906_, (boolean)true);
        }
    }

    public Item getDropItem() {
        return (Item)StalkerItems.DRONE_STALKER.get();
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public int getContainerSize() {
        return 27;
    }

    public ItemStack getItem(int p_219880_) {
        return this.getChestVehicleItem(p_219880_);
    }

    public ItemStack removeItem(int p_219882_, int p_219883_) {
        return this.removeChestVehicleItem(p_219882_, p_219883_);
    }

    public ItemStack removeItemNoUpdate(int p_219904_) {
        return this.removeChestVehicleItemNoUpdate(p_219904_);
    }

    public void setItem(int p_219885_, ItemStack p_219886_) {
        this.setChestVehicleItem(p_219885_, p_219886_);
    }

    public SlotAccess getSlot(int p_219918_) {
        return this.getChestVehicleSlot(p_219918_);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player p_219896_) {
        return this.isChestVehicleStillValid(p_219896_);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_219910_, Inventory inventory, Player player) {
        if (this.lootTable != null && player.isSpectator()) {
            return null;
        }
        this.unpackLootTable(inventory.player);
        return ChestMenu.threeRows((int)p_219910_, (Inventory)inventory, (Container)this);
    }

    public void unpackLootTable(@Nullable Player p_219914_) {
        this.unpackChestVehicleLootTable(p_219914_);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> resourceKey) {
        this.lootTable = resourceKey;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long p_219888_) {
        this.lootTableSeed = p_219888_;
    }

    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public void stopOpen(Player p_270286_) {
        this.level().gameEvent((Holder)GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.Context.of((Entity)p_270286_));
    }
}

