/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.event.handler;

import com.mafuyu404.diligentstalker.DiligentStalker;
import com.mafuyu404.diligentstalker.event.handler.StalkerControl;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.utils.StalkerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="diligentstalker", value={Dist.CLIENT})
public class ChunkLoadTask {
    public static final Queue<ClientboundLevelChunkWithLightPacket> TASK_QUEUE = new ConcurrentLinkedQueue<ClientboundLevelChunkWithLightPacket>();
    public static final Queue<ClientboundLevelChunkWithLightPacket> WORK_QUEUE = new ConcurrentLinkedQueue<ClientboundLevelChunkWithLightPacket>();
    public static int channelLimit = 0;
    public static volatile float DESIRED_CHUNKS_PER_TICK = 20.0f;

    public static void setDesiredChunksPerTick(float value) {
        DESIRED_CHUNKS_PER_TICK = Math.max(1.0f, value);
        DiligentStalker.debug(ChunkLoadTask.class, "update desiredChunksPerTick={}", Float.valueOf(DESIRED_CHUNKS_PER_TICK));
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        ClientboundLevelChunkWithLightPacket packet;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player == null || level == null) {
            return;
        }
        if (!Stalker.hasInstanceOf((Entity)player)) {
            return;
        }
        Entity stalker = Stalker.getInstanceOf((Entity)player).getStalker();
        if (!TASK_QUEUE.isEmpty() && WORK_QUEUE.isEmpty()) {
            ClientboundLevelChunkWithLightPacket packet2;
            ArrayList<ClientboundLevelChunkWithLightPacket> buffer = new ArrayList<ClientboundLevelChunkWithLightPacket>();
            while ((packet2 = TASK_QUEUE.poll()) != null) {
                buffer.add(packet2);
            }
            if (!buffer.isEmpty()) {
                DiligentStalker.debug(ChunkLoadTask.class, "preparing WORK_QUEUE: taskSize={}", buffer.size());
                List<ClientboundLevelChunkWithLightPacket> sorted = ChunkLoadTask.createChunksLoadTask(stalker, buffer);
                WORK_QUEUE.addAll(sorted);
                DiligentStalker.debug(ChunkLoadTask.class, "WORK_QUEUE prepared: size={}", WORK_QUEUE.size());
            }
        }
        if (WORK_QUEUE.isEmpty()) {
            return;
        }
        ClientPacketListener connection = mc.getConnection();
        if (connection == null) {
            return;
        }
        channelLimit = Math.max(1, (int)Math.ceil(DESIRED_CHUNKS_PER_TICK));
        for (int count = 0; count < channelLimit && (packet = WORK_QUEUE.poll()) != null; ++count) {
            ChunkPos pos = new ChunkPos(packet.getX(), packet.getZ());
            boolean hasBefore = level.getChunkSource().hasChunk(pos.x, pos.z);
            DiligentStalker.debug(ChunkLoadTask.class, "begin send x={} z={} hasBefore={}", pos.x, pos.z, hasBefore);
            if (!hasBefore) {
                connection.handleLevelChunkWithLight(packet);
            }
            boolean hasAfter = level.getChunkSource().hasChunk(pos.x, pos.z);
            DiligentStalker.debug(ChunkLoadTask.class, "end send x={} z={} hasAfter={} (sent={})", pos.x, pos.z, hasAfter, !hasBefore);
        }
    }

    public static List<ClientboundLevelChunkWithLightPacket> createChunksLoadTask(Entity stalker, List<ClientboundLevelChunkWithLightPacket> toLoadChunks) {
        ArrayList<ClientboundLevelChunkWithLightPacket> safeList = new ArrayList<ClientboundLevelChunkWithLightPacket>(toLoadChunks);
        safeList.removeIf(Objects::isNull);
        if (safeList.isEmpty()) {
            return safeList;
        }
        Vec3 direction = StalkerUtil.calculateViewVector(StalkerControl.xRot, StalkerControl.yRot);
        Vec3 startCenter = stalker.chunkPosition().getWorldPosition().getCenter();
        LinkedHashMap<Long, ClientboundLevelChunkWithLightPacket> uniq = new LinkedHashMap<Long, ClientboundLevelChunkWithLightPacket>();
        for (ClientboundLevelChunkWithLightPacket packet2 : safeList) {
            long key = ChunkPos.asLong((int)packet2.getX(), (int)packet2.getZ());
            uniq.putIfAbsent(key, packet2);
        }
        ArrayList<ClientboundLevelChunkWithLightPacket> dedup = new ArrayList<ClientboundLevelChunkWithLightPacket>(uniq.values());
        ChunkLoadTask.sortChunks(dedup, packet -> {
            Vec3 end = new ChunkPos(packet.getX(), packet.getZ()).getWorldPosition().getCenter();
            return -StalkerUtil.calculateViewAlignment(direction, startCenter, end);
        });
        ChunkLoadTask.sortChunks(dedup, packet -> {
            Vec3 end = new ChunkPos(packet.getX(), packet.getZ()).getWorldPosition().getCenter();
            return end.subtract(startCenter).length();
        });
        DiligentStalker.debug(ChunkLoadTask.class, "createChunksLoadTask: total={} result={}", safeList.size(), dedup.size());
        return dedup;
    }

    public static void sortChunks(List<ClientboundLevelChunkWithLightPacket> chunks, Function<ClientboundLevelChunkWithLightPacket, Double> handler) {
        if (chunks == null || chunks.size() <= 1) {
            return;
        }
        chunks.removeIf(Objects::isNull);
        chunks.sort(Comparator.comparingDouble(handler::apply));
    }

    public static void enqueue(ClientboundLevelChunkWithLightPacket packet) {
        if (packet == null) {
            return;
        }
        TASK_QUEUE.offer(packet);
        DiligentStalker.debug(ChunkLoadTask.class, "enqueue chunk packet x={} z={} queueSize={}", packet.getX(), packet.getZ(), TASK_QUEUE.size());
    }
}

