/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.event.handler;

import com.mafuyu404.diligentstalker.compat.KeyPrompts;
import com.mafuyu404.diligentstalker.component.StalkerDataComponents;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.item.StalkerMasterItem;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import com.mafuyu404.diligentstalker.utils.ControllableUtils;
import com.mafuyu404.diligentstalker.utils.StalkerUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="diligentstalker", value={Dist.CLIENT})
public class DroneStalkerHUD {
    private static int SIGNAL_RADIUS = 0;
    public static boolean LPress = false;
    public static boolean RPress = false;

    @SubscribeEvent
    public static void skp(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (Stalker.hasInstanceOf((Entity)mc.player)) {
            KeyPrompts.show("key.diligentstalker.view.desc");
            KeyPrompts.show("key.diligentstalker.control.desc");
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            ResourceLocation icon = player.getSkin().texture();
            ResourceLocation item = ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"textures/entity/drone_stalker_forward.png");
            if (Stalker.hasInstanceOf((Entity)player)) {
                Entity stalker = Stalker.getInstanceOf((Entity)player).getStalker();
                Vec3 direction = stalker.position().subtract(player.position());
                float yRot = StalkerUtil.getYRotFromVec3(direction);
                int distance = (int)direction.length();
                if (ControllableUtils.isControllable(stalker)) {
                    if (SIGNAL_RADIUS == 0) {
                        SIGNAL_RADIUS = ControllableUtils.getSignalRadius(stalker);
                    }
                    float signal_percent = 1.0f - 1.0f * (float)distance / (float)SIGNAL_RADIUS;
                    float fuel_percent = ControllableUtils.getFuelPercent(stalker);
                    List<ArcSection> sections = List.of(new ArcSection(-157.5f, 0.375f, 0.7f, 0.7f, 0.7f, 0.4f), new ArcSection(-157.5f - 67.5f * (1.0f - signal_percent), signal_percent * 0.375f, 0.8f, 0.8f, 0.8f, 1.0f), new ArcSection(-22.5f, 0.375f, 0.6f, 0.8f, 1.0f, 0.4f), new ArcSection(-22.5f + 67.5f * (1.0f - fuel_percent), fuel_percent * 0.375f, 0.6f, 0.8f, 1.0f, 1.0f), new ArcSection(112.5f, 0.125f, 1.0f, 0.6f, 0.6f, 0.4f), new ArcSection(112.5f, LPress ? 0.125f : 0.0f, 1.0f, 0.6f, 0.6f, 1.0f), new ArcSection(67.5f, 0.125f, 0.6f, 1.0f, 0.6f, 0.4f), new ArcSection(67.5f, RPress ? 0.125f : 0.0f, 0.6f, 1.0f, 0.6f, 1.0f));
                    DroneStalkerHUD.drawHud(guiGraphics, sections);
                }
                DroneStalkerHUD.drawPlayerPosition(guiGraphics, yRot - ClientStalkerUtil.getCameraYRot() + 180.0f, distance, icon);
            } else {
                BlockPos pos;
                ItemStack itemStack = player.getMainHandItem();
                if (itemStack.getItem() instanceof StalkerMasterItem && (pos = (BlockPos)itemStack.get((DataComponentType)StalkerDataComponents.STALKER_POSITION.get())) != null) {
                    Vec3 direction = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).subtract(player.position());
                    float yRot = StalkerUtil.getYRotFromVec3(direction);
                    int distance = (int)direction.length();
                    float signal_percent = 1.0f - 1.0f * (float)distance / (float)SIGNAL_RADIUS;
                    List<ArcSection> sections = List.of(new ArcSection(-157.5f, 0.375f, 0.7f, 0.7f, 0.7f, 0.4f), new ArcSection(-157.5f - 67.5f * (1.0f - signal_percent), signal_percent * 0.375f, 0.8f, 0.8f, 0.8f, 1.0f));
                    DroneStalkerHUD.drawHud(event.getGuiGraphics(), sections);
                    DroneStalkerHUD.drawPlayerPosition(event.getGuiGraphics(), yRot - player.getYRot(), distance, item);
                }
            }
        }
    }

    private static void drawHud(GuiGraphics guiGraphics, List<ArcSection> sections) {
        PoseStack poseStack = guiGraphics.pose();
        Window window = Minecraft.getInstance().getWindow();
        int screenWidth = window.getGuiScaledWidth();
        int screenHeight = window.getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        float radius = 80.0f;
        float thickness = 3.0f;
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        Tesselator tessellator = Tesselator.getInstance();
        float GAP = 2.0f;
        float TOTAL_AVAILABLE = 354.0f;
        for (ArcSection section : sections) {
            float sectionAngle = 354.0f * section.percentage;
            if (sectionAngle < 0.1f) continue;
            float start = section.centerAngle - sectionAngle / 2.0f + 1.0f;
            float end = section.centerAngle + sectionAngle / 2.0f - 1.0f;
            BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
            RenderSystem.setShaderColor((float)section.r, (float)section.g, (float)section.b, (float)section.a);
            int segments = Math.max(2, (int)(sectionAngle * 1.5f));
            for (int i = 0; i <= segments; ++i) {
                double angle = Math.toRadians(start + (end - start) * (float)i / (float)segments);
                double ox = (double)centerX + (double)radius * Math.cos(angle);
                double oy = (double)centerY + (double)radius * Math.sin(angle);
                double ix = (double)centerX + (double)(radius - thickness) * Math.cos(angle);
                double iy = (double)centerY + (double)(radius - thickness) * Math.sin(angle);
                buffer.addVertex((float)ox, (float)oy, 0.0f);
                buffer.addVertex((float)ix, (float)iy, 0.0f);
            }
            MeshData meshData = buffer.build();
            if (meshData == null) continue;
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static void drawPlayerPosition(GuiGraphics guiGraphics, float rotate, int distance, ResourceLocation icon) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        Window window = Minecraft.getInstance().getWindow();
        int screenWidth = window.getGuiScaledWidth();
        int screenHeight = window.getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        float radius = 90.0f;
        double theta = Math.toRadians(90.0f - rotate);
        double xPos = (double)centerX + (double)radius * Math.cos(theta);
        double yPos = (double)centerY - (double)radius * Math.sin(theta);
        int headSize = 12;
        int x = (int)(xPos - (double)headSize / 2.0);
        int y = (int)(yPos - (double)headSize / 2.0) - 2;
        guiGraphics.blit(icon, x, y, headSize, headSize, 8.0f, 8.0f, 8, 8, 64, 64);
        String text = distance + "m";
        Font font = Minecraft.getInstance().font;
        int textColor = -1;
        int outlineColor = -16777216;
        int textWidth = font.width(text);
        int textX = x + (headSize - textWidth) / 2;
        int textY = y + headSize - 2;
        guiGraphics.drawString(font, text, textX - 1, textY, outlineColor, false);
        guiGraphics.drawString(font, text, textX + 1, textY, outlineColor, false);
        guiGraphics.drawString(font, text, textX, textY - 1, outlineColor, false);
        guiGraphics.drawString(font, text, textX, textY + 1, outlineColor, false);
        guiGraphics.drawString(font, text, textX, textY, textColor, false);
    }

    private static class ArcSection {
        final float centerAngle;
        final float percentage;
        final float r;
        final float g;
        final float b;
        final float a;

        ArcSection(float center, float percent, float r, float g, float b, float a) {
            this.centerAngle = center;
            this.percentage = percent;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }
    }
}

