/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.event.handler;

import com.mafuyu404.diligentstalker.api.IControllable;
import com.mafuyu404.diligentstalker.entity.ArrowStalkerEntity;
import com.mafuyu404.diligentstalker.entity.DroneStalkerEntity;
import com.mafuyu404.diligentstalker.entity.VoidStalkerEntity;
import com.mafuyu404.diligentstalker.event.handler.DroneStalkerHUD;
import com.mafuyu404.diligentstalker.init.NetworkHandler;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.item.StalkerCoreItem;
import com.mafuyu404.diligentstalker.network.EntityDataPacket;
import com.mafuyu404.diligentstalker.network.RClickBlockPacket;
import com.mafuyu404.diligentstalker.registry.KeyBindings;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import com.mafuyu404.diligentstalker.utils.ControllableUtils;
import com.mafuyu404.diligentstalker.utils.StalkerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="diligentstalker", value={Dist.CLIENT})
public class StalkerControl {
    public static float fixedXRot;
    public static float fixedYRot;
    public static float xRot;
    public static float yRot;
    public static boolean screen;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Entity stalker;
        boolean bl = screen = Minecraft.getInstance().screen != null;
        if (screen) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ClientLevel level = player.clientLevel;
        for (Entity entity : level.entitiesForRendering()) {
            if (!ClientStalkerUtil.matchConnectingTarget(entity)) continue;
            Stalker.connect((Player)player, entity);
            ClientStalkerUtil.setConnectingTarget(null);
            break;
        }
        if ((stalker = ClientStalkerUtil.getLocalStalker()) != null) {
            ClientStalkerUtil.setVisualCenter(null);
            if (ControllableUtils.isControllable(stalker)) {
                if (ControllableUtils.isCameraControlling(stalker)) {
                    stalker.setXRot(xRot);
                    stalker.setYRot(yRot);
                }
                StalkerControl.syncControl();
            }
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide().isClient()) {
            Player player = event.getEntity();
            if (player.isShiftKeyDown()) {
                return;
            }
            if (event.getItemStack().getItem() instanceof StalkerCoreItem) {
                Stalker.connect(player, event.getTarget());
                event.setCanceled(true);
            } else {
                Entity entity = event.getTarget();
                if (entity instanceof DroneStalkerEntity) {
                    DroneStalkerEntity stalker = (DroneStalkerEntity)entity;
                    Stalker.connect(player, (Entity)stalker);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onControl(InputEvent.Key event) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        Options options = Minecraft.getInstance().options;
        Entity stalker = ClientStalkerUtil.getLocalStalker();
        if (stalker == null) {
            return;
        }
        StalkerControl.updateControlMap();
        if (event.getAction() == 1) {
            if (event.getKey() == KeyBindings.DISCONNECT.getKey().getValue() && Stalker.hasInstanceOf((Entity)player)) {
                Stalker.getInstanceOf((Entity)player).disconnect();
            }
            if (event.getKey() == KeyBindings.VIEW.getKey().getValue()) {
                ControllableUtils.switchCameraState(stalker);
            }
            if (event.getKey() == KeyBindings.CONTROL.getKey().getValue()) {
                ControllableUtils.turnActionControlling(stalker);
            }
        }
        if (StalkerUtil.ControlMap.containsValue(event.getKey())) {
            StalkerControl.syncControl();
        }
    }

    @SubscribeEvent
    public static void onUse(PlayerInteractEvent.RightClickBlock event) {
        if (event.getSide().isClient() && Stalker.hasInstanceOf((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUse(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide().isClient() && Stalker.hasInstanceOf((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAction(InputEvent.MouseButton.Pre event) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (!Stalker.hasInstanceOf((Entity)player)) {
            return;
        }
        if (event.getButton() == 1) {
            boolean bl = DroneStalkerHUD.RPress = event.getAction() == 1;
        }
        if (event.getButton() == 0) {
            boolean bl = DroneStalkerHUD.LPress = event.getAction() == 1;
        }
        if (event.getAction() != 1) {
            return;
        }
        if (event.getButton() != 1) {
            event.setCanceled(true);
            return;
        }
        Stalker instance = Stalker.getInstanceOf((Entity)player);
        if (ControllableUtils.isControllable(instance.getStalker())) {
            Vec3 viewVector = StalkerUtil.calculateViewVector(xRot, yRot);
            BlockHitResult traceResult = StalkerUtil.rayTraceBlocks(player.level(), (Entity)player, ClientStalkerUtil.getCameraPosition(), viewVector, 4.0);
            if (traceResult.getType() == HitResult.Type.BLOCK) {
                NetworkHandler.sendToServer(new RClickBlockPacket(ClientStalkerUtil.getCameraPosition(), viewVector));
                StalkerControl.RightClickBlock((Player)player, ClientStalkerUtil.getCameraPosition(), viewVector);
            }
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent event) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (!Stalker.hasInstanceOf((Entity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    public static CompoundTag handleInput() {
        Options options = Minecraft.getInstance().options;
        CompoundTag input = new CompoundTag();
        StalkerUtil.ControlMap.forEach((s, key) -> input.putBoolean(s, ClientStalkerUtil.isKeyPressed(key)));
        Entity stalker = ClientStalkerUtil.getLocalStalker();
        if (stalker != null && ControllableUtils.isCameraControlling(stalker)) {
            input.putFloat("xRot", xRot);
            input.putFloat("yRot", yRot);
        }
        return input;
    }

    public static void syncControl() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        StalkerControl.updateControlMap();
        CompoundTag input = StalkerControl.handleInput();
        Entity stalker = ClientStalkerUtil.getLocalStalker();
        if (ControllableUtils.isControllable(stalker)) {
            ((IControllable)stalker).pushAdditionalControl(input);
            if (!ControllableUtils.isActionControlling(stalker)) {
                input = new CompoundTag();
            }
        }
        player.getPersistentData().put("StalkerControlInput", (Tag)input);
        NetworkHandler.sendToServer(new EntityDataPacket(player.getId(), player.getPersistentData()));
    }

    public static void RightClickBlock(Player player, Vec3 position, Vec3 viewVec) {
        player.displayClientMessage((Component)Component.translatable((String)"message.diligentstalker.under_maintaining").withStyle(ChatFormatting.RED), true);
    }

    public static void connect(Player player, Entity stalker) {
        if (!player.isLocalPlayer()) {
            return;
        }
        fixedXRot = player.getXRot();
        fixedYRot = player.getYRot();
        xRot = fixedXRot;
        yRot = fixedYRot;
        if (ControllableUtils.isControllable(stalker)) {
            xRot = stalker.getXRot();
            yRot = stalker.getYRot();
            ControllableUtils.setCameraControlling(stalker);
        }
    }

    @SubscribeEvent
    public static void onClientEnter(EntityJoinLevelEvent event) {
        Object stalker;
        Entity entity;
        if (!event.getLevel().isClientSide) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ClientStalkerUtil.matchConnectingTarget(event.getEntity())) {
            Stalker.connect((Player)player, event.getEntity());
        }
        if ((entity = event.getEntity()) instanceof ArrowStalkerEntity && (stalker = (ArrowStalkerEntity)entity).getOwner() != null && stalker.getOwner().getUUID().equals(player.getUUID())) {
            if (Stalker.hasInstanceOf((Entity)player)) {
                return;
            }
            Stalker.connect((Player)player, (Entity)stalker);
        }
        if ((entity = event.getEntity()) instanceof VoidStalkerEntity && (stalker = (VoidStalkerEntity)entity).getOwner() != null && stalker.getOwner().getUUID().equals(player.getUUID())) {
            if (Stalker.hasInstanceOf((Entity)player)) {
                return;
            }
            Stalker.connect((Player)player, (Entity)stalker);
        }
    }

    private static void updateControlMap() {
        Options options = Minecraft.getInstance().options;
        StalkerUtil.ControlMap.put("Up", options.keyUp.getKey().getValue());
        StalkerUtil.ControlMap.put("Down", options.keyDown.getKey().getValue());
        StalkerUtil.ControlMap.put("Left", options.keyLeft.getKey().getValue());
        StalkerUtil.ControlMap.put("Right", options.keyRight.getKey().getValue());
        StalkerUtil.ControlMap.put("Jump", options.keyJump.getKey().getValue());
        StalkerUtil.ControlMap.put("Shift", options.keyShift.getKey().getValue());
    }

    static {
        screen = false;
    }
}

