/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.init;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoader {
    private static HashMap<ResourceLocation, ChunkLoader> dimension = new HashMap();
    private final ServerLevel level;
    private final Set<ChunkPos> forcedChunks = new HashSet<ChunkPos>();

    public static ChunkLoader of(ServerLevel serverLevel) {
        ResourceLocation id = serverLevel.dimension().location();
        if (!dimension.containsKey(id)) {
            dimension.put(id, new ChunkLoader(serverLevel));
        }
        return dimension.get(id);
    }

    public static void init() {
        dimension = new HashMap();
    }

    public ChunkLoader(ServerLevel level) {
        this.level = level;
    }

    public void addChunk(ChunkPos chunkPos) {
        if (!this.forcedChunks.contains(chunkPos)) {
            this.level.getChunkSource().addRegionTicket(TicketType.FORCED, chunkPos, 2, (Object)chunkPos);
            this.forcedChunks.add(chunkPos);
        }
    }

    public void removeAll() {
        for (ChunkPos chunkPos : this.forcedChunks) {
            this.level.getChunkSource().removeRegionTicket(TicketType.FORCED, chunkPos, 2, (Object)chunkPos);
        }
        this.forcedChunks.clear();
    }
}

