/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.init;

import com.mafuyu404.diligentstalker.event.StalkerEvents;
import com.mafuyu404.diligentstalker.event.handler.StalkerControl;
import com.mafuyu404.diligentstalker.init.NetworkHandler;
import com.mafuyu404.diligentstalker.network.StalkerSyncPacket;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import com.mafuyu404.diligentstalker.utils.ServerStalkerUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class Stalker {
    private final UUID playerUUID;
    private final int stalkerId;
    public final Level level;
    public static final HashMap<UUID, Integer> InstanceMap = new HashMap();
    private static final HashMap<Integer, UUID> StalkerToPlayerMap = new HashMap();

    public Stalker(UUID playerUUID, int stalkerId, Level level) {
        this.playerUUID = playerUUID;
        this.stalkerId = stalkerId;
        this.level = level;
    }

    public Player getPlayer() {
        return this.level.getPlayerByUUID(this.playerUUID);
    }

    public Entity getStalker() {
        return this.level.getEntity(this.stalkerId);
    }

    public void disconnect() {
        Player player;
        if (this.level.isClientSide) {
            NetworkHandler.sendToServer(new StalkerSyncPacket(this.stalkerId, false));
            ClientStalkerUtil.cancelRemoteConnect();
        }
        StalkerEvents.DisconnectEvent event = new StalkerEvents.DisconnectEvent(this.getPlayer(), this.getStalker());
        NeoForge.EVENT_BUS.post((Event)event);
        if (!this.level.isClientSide && (player = this.getPlayer()) != null) {
            ServerStalkerUtil.setVisualCenter(player, BlockPos.ZERO);
            player.getPersistentData().putBoolean("LoadingCacheChunk", true);
        }
        InstanceMap.remove(this.playerUUID);
        StalkerToPlayerMap.remove(this.stalkerId);
    }

    public static Stalker connect(Player player, Entity stalker) {
        if (player == null || stalker == null) {
            return null;
        }
        if (Stalker.hasInstanceOf((Entity)player) || Stalker.hasInstanceOf(stalker)) {
            return null;
        }
        if (player.level().isClientSide) {
            StalkerControl.connect(player, stalker);
            NetworkHandler.sendToServer(new StalkerSyncPacket(stalker.getId(), true));
            ClientStalkerUtil.cancelRemoteConnect();
        }
        StalkerEvents.ConnectEvent event = new StalkerEvents.ConnectEvent(player, stalker);
        NeoForge.EVENT_BUS.post((Event)event);
        InstanceMap.put(player.getUUID(), stalker.getId());
        StalkerToPlayerMap.put(stalker.getId(), player.getUUID());
        return new Stalker(player.getUUID(), stalker.getId(), player.level());
    }

    public static boolean hasInstanceOf(Entity entity) {
        if (entity == null) {
            return false;
        }
        boolean isPlayer = InstanceMap.containsKey(entity.getUUID());
        boolean isStalker = StalkerToPlayerMap.containsKey(entity.getId());
        return isPlayer || isStalker;
    }

    public static Stalker getInstanceOf(Entity entity) {
        UUID playerUUID;
        Integer stalkerId;
        if (entity == null) {
            return null;
        }
        if (InstanceMap.containsKey(entity.getUUID()) && (stalkerId = InstanceMap.get(entity.getUUID())) != null) {
            return new Stalker(entity.getUUID(), stalkerId, entity.level());
        }
        if (StalkerToPlayerMap.containsKey(entity.getId()) && (playerUUID = StalkerToPlayerMap.get(entity.getId())) != null) {
            return new Stalker(playerUUID, entity.getId(), entity.level());
        }
        return null;
    }

    public static void cleanupPlayer(UUID playerUUID) {
        Integer stalkerId = InstanceMap.remove(playerUUID);
        if (stalkerId != null) {
            StalkerToPlayerMap.remove(stalkerId);
        }
    }

    public static void cleanupStalker(int stalkerId) {
        UUID playerUUID = StalkerToPlayerMap.remove(stalkerId);
        if (playerUUID != null) {
            InstanceMap.remove(playerUUID);
        }
    }

    public static void cleanupLevel(Level level) {
        InstanceMap.entrySet().removeIf(entry -> {
            UUID playerUUID = (UUID)entry.getKey();
            Integer stalkerId = (Integer)entry.getValue();
            Player player = level.getPlayerByUUID(playerUUID);
            Entity stalker = level.getEntity(stalkerId.intValue());
            if (player != null || stalker != null) {
                StalkerToPlayerMap.remove(stalkerId);
                return true;
            }
            return false;
        });
    }

    public static void cleanupInvalidMappings(Level level) {
        InstanceMap.entrySet().removeIf(entry -> {
            UUID playerUUID = (UUID)entry.getKey();
            Integer stalkerId = (Integer)entry.getValue();
            Player player = level.getPlayerByUUID(playerUUID);
            Entity stalker = level.getEntity(stalkerId.intValue());
            if (player == null || stalker == null) {
                StalkerToPlayerMap.remove(stalkerId);
                return true;
            }
            return false;
        });
    }

    public static int getMappingCount() {
        return InstanceMap.size();
    }
}

