/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.init;

import com.google.common.collect.ImmutableList;
import com.mafuyu404.diligentstalker.mixin.InventoryAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class VirtualInventory
extends Inventory {
    public int size;
    public int playerInventorySize;

    public VirtualInventory(int size, Player player) {
        super(Objects.requireNonNull(player));
        ((InventoryAccessor)((Object)this)).setItems((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
        ((InventoryAccessor)((Object)this)).setCompartments((List<NonNullList<ItemStack>>)ImmutableList.of((Object)this.items, (Object)this.armor, (Object)this.offhand));
        this.size = size;
    }

    public ItemHandler getHandler() {
        return new ItemHandler(this);
    }

    public static class ItemHandler
    implements IItemHandler {
        private final VirtualInventory virtualInventory;

        public ItemHandler(VirtualInventory virtualInventory) {
            this.virtualInventory = virtualInventory;
        }

        public int getSlots() {
            return this.virtualInventory.size;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.virtualInventory.getItem(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return null;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack itemStack = this.virtualInventory.getItem(slot);
            ItemStack result = itemStack.copy();
            itemStack.setCount(itemStack.getCount() - amount);
            result.setCount(amount);
            return result;
        }

        public int getSlotLimit(int slot) {
            return this.virtualInventory.size;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

