/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.item;

import com.mafuyu404.diligentstalker.component.StalkerDataComponents;
import com.mafuyu404.diligentstalker.event.handler.StalkerManage;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class StalkerMasterItem
extends Item {
    public StalkerMasterItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown()) {
            UUID stalkerId = (UUID)stack.get((DataComponentType)StalkerDataComponents.STALKER_ID.get());
            if (stalkerId == null || Stalker.hasInstanceOf((Entity)player)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            player.startUsingItem(hand);
            if (player.isLocalPlayer() && !Stalker.hasInstanceOf((Entity)player)) {
                BlockPos center = StalkerMasterItem.entryOfUsingStalkerMaster(player);
                UUID entityUUID = StalkerMasterItem.uuidOfUsingStalkerMaster(player);
                if (center != null && entityUUID != null) {
                    ClientStalkerUtil.tryRemoteConnect(center, entity -> entity.getUUID().equals(entityUUID));
                }
            }
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int timeLeft) {
        Player player;
        if (entity instanceof Player && !Stalker.hasInstanceOf((Entity)(player = (Player)entity))) {
            ClientStalkerUtil.cancelRemoteConnect();
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int n = this.getUseDuration(stack, entity) - timeLeft;
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        BlockPos pos = (BlockPos)stack.get((DataComponentType)StalkerDataComponents.STALKER_POSITION.get());
        if (pos != null) {
            tooltip.add((Component)Component.literal((String)("> " + pos.toShortString() + " <")).withStyle(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"item.diligentstalker.stalker_master.intro1").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"item.diligentstalker.stalker_master.intro2").withStyle(ChatFormatting.GOLD));
    }

    public static BlockPos entryOfUsingStalkerMaster(Player player) {
        ItemStack stack;
        UUID stalkerId;
        if (player != null && player.isUsingItem() && player.getMainHandItem().getItem() instanceof StalkerMasterItem && (stalkerId = (UUID)(stack = player.getMainHandItem()).get((DataComponentType)StalkerDataComponents.STALKER_ID.get())) != null && StalkerManage.DronePosition.containsKey(stalkerId)) {
            return StalkerManage.DronePosition.get(stalkerId).getValue();
        }
        return null;
    }

    public static UUID uuidOfUsingStalkerMaster(Player player) {
        if (player != null && player.isUsingItem() && player.getMainHandItem().getItem() instanceof StalkerMasterItem) {
            ItemStack stack = player.getMainHandItem();
            return (UUID)stack.get((DataComponentType)StalkerDataComponents.STALKER_ID.get());
        }
        return null;
    }
}

