/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.item;

import com.mafuyu404.diligentstalker.entity.VoidStalkerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VoidStalkerItem
extends Item {
    public VoidStalkerItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            VoidStalkerEntity stalker = new VoidStalkerEntity((LivingEntity)player, level);
            stalker.setItem(itemstack);
            stalker.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 1.0f);
            level.addFreshEntity((Entity)stalker);
            player.getCooldowns().addCooldown((Item)this, 30);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }
}

