/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.mixin;

import com.mafuyu404.diligentstalker.api.IChunkMap;
import com.mafuyu404.diligentstalker.init.ChunkLoader;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.registry.Config;
import com.mafuyu404.diligentstalker.utils.ServerStalkerUtil;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.event.EventHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMapMixin
implements IChunkMap {
    @Shadow
    @Nullable
    public abstract ChunkHolder getVisibleChunkIfPresent(long var1);

    @Shadow
    private void applyChunkTrackingView(ServerPlayer player, ChunkTrackingView view) {
    }

    @Shadow
    public abstract int getPlayerViewDistance(ServerPlayer var1);

    @Shadow
    public abstract void waitForLightBeforeSending(ChunkPos var1, int var2);

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    private void diligentstalker$overrideMove(ServerPlayer player, CallbackInfo ci) {
        boolean hasStalkerConnection = Stalker.hasInstanceOf((Entity)player);
        ChunkPos stalkerPos = null;
        if (hasStalkerConnection) {
            stalkerPos = Stalker.getInstanceOf((Entity)player).getStalker().chunkPosition();
        }
        if (ServerStalkerUtil.hasVisualCenter((Player)player)) {
            this.loadLevelChunk(player, new ChunkPos(ServerStalkerUtil.getVisualCenter((Player)player)));
        }
        ChunkPos center = null;
        if (hasStalkerConnection) {
            center = stalkerPos;
            ci.cancel();
        }
        if (player.getPersistentData().getBoolean("LoadingCacheChunk")) {
            center = player.chunkPosition();
            player.getPersistentData().putBoolean("LoadingCacheChunk", false);
        }
        if (center == null) {
            return;
        }
        int radius = (Integer)Config.RENDER_RADIUS_NORMAL.get();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkPos pos = new ChunkPos(center.x + x, center.z + z);
                ChunkLoader.of(player.serverLevel()).addChunk(pos);
                this.loadLevelChunk(player, pos);
            }
        }
        ci.cancel();
    }

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")}, cancellable=true)
    private void ds$updateChunkTracking(ServerPlayer player, CallbackInfo ci) {
        boolean hasStalkerConnection = Stalker.hasInstanceOf((Entity)player);
        ChunkPos stalkerPos = null;
        if (hasStalkerConnection) {
            stalkerPos = Stalker.getInstanceOf((Entity)player).getStalker().chunkPosition();
        }
        if (hasStalkerConnection && stalkerPos != null) {
            int viewDistance = this.getPlayerViewDistance(player);
            this.waitForLightBeforeSending(stalkerPos, viewDistance);
            this.applyChunkTrackingView(player, ChunkTrackingView.of((ChunkPos)stalkerPos, (int)viewDistance));
            ci.cancel();
        }
    }

    @Inject(method={"isChunkTracked"}, at={@At(value="HEAD")}, cancellable=true)
    private void ds$isChunkTracked(ServerPlayer player, int x, int z, CallbackInfoReturnable<Boolean> cir) {
        boolean decision;
        boolean loadedVisible;
        int viewDistance = this.getPlayerViewDistance(player);
        boolean originalContains = player.getChunkTrackingView().contains(x, z);
        long posLong = ChunkPos.asLong((int)x, (int)z);
        boolean pending = player.connection.chunkSender.isPending(posLong);
        boolean hasStalkerConnection = Stalker.hasInstanceOf((Entity)player);
        ChunkPos stalkerPos = null;
        boolean containsStalkerView = false;
        if (hasStalkerConnection) {
            stalkerPos = Stalker.getInstanceOf((Entity)player).getStalker().chunkPosition();
            containsStalkerView = ChunkTrackingView.isWithinDistance((int)stalkerPos.x, (int)stalkerPos.z, (int)viewDistance, (int)x, (int)z, (boolean)true);
        }
        boolean bl = loadedVisible = this.getVisibleChunkIfPresent(posLong) != null;
        boolean bl2 = hasStalkerConnection ? containsStalkerView : (decision = originalContains && (!pending || loadedVisible));
        if (!decision) {
            if (hasStalkerConnection) {
                String reason = "outside_stalker_view";
            } else if (!originalContains) {
                String reason = "outside_player_view";
            } else {
                String string = "pending_chunk";
            }
        } else {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Override
    public void loadLevelChunk(ServerPlayer player, ChunkPos chunkPos) {
        ChunkHolder holder = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (holder == null) {
            return;
        }
        LevelChunk levelChunk = holder.getTickingChunk();
        if (levelChunk == null) {
            return;
        }
        player.connection.chunkSender.markChunkPendingToSend(levelChunk);
        EventHooks.fireChunkWatch((ServerPlayer)player, (LevelChunk)levelChunk, (ServerLevel)player.serverLevel());
    }
}

