/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.mixin;

import com.mafuyu404.diligentstalker.entity.DroneStalkerEntity;
import com.mafuyu404.diligentstalker.event.handler.StalkerControl;
import com.mafuyu404.diligentstalker.event.handler.StalkerManage;
import com.mafuyu404.diligentstalker.init.Stalker;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private Level level;
    @Shadow
    private ChunkPos chunkPosition;
    @Shadow
    protected UUID uuid;

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract BlockPos blockPosition();

    @Inject(method={"setXRot"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectXRot(float xRot, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            if (!player.isLocalPlayer()) {
                return;
            }
            if (!Stalker.hasInstanceOf((Entity)player)) {
                return;
            }
            if (!StalkerControl.screen) {
                StalkerControl.xRot += xRot - StalkerControl.fixedXRot;
            }
            ci.cancel();
        }
    }

    @Inject(method={"setYRot"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectYRot(float yRot, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            if (!player.isLocalPlayer()) {
                return;
            }
            if (!Stalker.hasInstanceOf((Entity)player)) {
                return;
            }
            if (!StalkerControl.screen) {
                StalkerControl.yRot += yRot - StalkerControl.fixedYRot;
            }
            ci.cancel();
        }
    }

    @Inject(method={"distanceToSqr(DDD)D"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyDistance(double p_20276_, double p_20277_, double p_20278_, CallbackInfoReturnable<Double> cir) {
        Player player;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player && Stalker.hasInstanceOf((Entity)(player = (Player)entityMixin))) {
            cir.setReturnValue((Object)1.0);
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")}, cancellable=true)
    private void avoidVoidFall(double p_20210_, double p_20211_, double p_20212_, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            if (!this.level.isClientSide) {
                return;
            }
            if (!Stalker.hasInstanceOf((Entity)player)) {
                return;
            }
            if (!this.level.getChunkSource().hasChunk(this.chunkPosition.x, this.chunkPosition.z)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="RETURN")})
    private void position(double p_20344_, double p_20345_, double p_20346_, CallbackInfo ci) {
        if (this instanceof DroneStalkerEntity) {
            if (this.level.isClientSide) {
                return;
            }
            final String levelKey = this.level.dimension().toString();
            final BlockPos blockPos = this.blockPosition();
            StalkerManage.DronePosition.put(this.uuid, new Map.Entry<String, BlockPos>(this){

                @Override
                public String getKey() {
                    return levelKey;
                }

                @Override
                public BlockPos getValue() {
                    return blockPos;
                }

                @Override
                public BlockPos setValue(BlockPos value) {
                    return null;
                }
            });
        }
    }
}

