/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.mixin.client;

import com.mafuyu404.diligentstalker.event.handler.StalkerControl;
import com.mafuyu404.diligentstalker.init.Stalker;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import com.mafuyu404.diligentstalker.utils.ControllableUtils;
import com.mafuyu404.diligentstalker.utils.StalkerUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;
    @Shadow
    private Vec3 position;
    @Shadow
    @Final
    private Quaternionf rotation;
    @Shadow
    @Final
    private Vector3f forwards;
    @Shadow
    @Final
    private Vector3f up;
    @Shadow
    @Final
    private Vector3f left;
    private static final Vector3f FORWARDS = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f LEFT = new Vector3f(-1.0f, 0.0f, 0.0f);

    @ModifyVariable(method={"setPosition(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private Vec3 modifyPosition(Vec3 pos1) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (Stalker.hasInstanceOf((Entity)player)) {
            Vec3 pos0 = this.position;
            double x = StalkerUtil.lerp(pos0.x, pos1.x);
            double y = StalkerUtil.lerp(pos0.y, pos1.y);
            double z = StalkerUtil.lerp(pos0.z, pos1.z);
            return new Vec3(x, y, z);
        }
        if (ClientStalkerUtil.getVisualCenter() != null) {
            return ClientStalkerUtil.getVisualCenter().getCenter();
        }
        return pos1;
    }

    @Inject(method={"setRotation(FF)V"}, at={@At(value="RETURN")})
    private void modifyRotate2Param(float yRot, float xRot, CallbackInfo ci) {
        Entity stalker = ClientStalkerUtil.getLocalStalker();
        if (stalker != null && !ControllableUtils.isCameraFollowing(stalker)) {
            this.updateCameraRotation(StalkerControl.yRot, StalkerControl.xRot, 0.0f);
        }
    }

    @Inject(method={"setRotation(FFF)V"}, at={@At(value="RETURN")})
    private void modifyRotate3Param(float yRot, float xRot, float roll, CallbackInfo ci) {
        Entity stalker = ClientStalkerUtil.getLocalStalker();
        if (stalker != null && !ControllableUtils.isCameraFollowing(stalker)) {
            this.updateCameraRotation(StalkerControl.yRot, StalkerControl.xRot, 0.0f);
        }
    }

    private void updateCameraRotation(float yRot, float xRot, float roll) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.rotation.rotationYXZ((float)Math.PI - yRot * ((float)Math.PI / 180), -xRot * ((float)Math.PI / 180), -roll * ((float)Math.PI / 180));
        FORWARDS.rotate((Quaternionfc)this.rotation, this.forwards);
        UP.rotate((Quaternionfc)this.rotation, this.up);
        LEFT.rotate((Quaternionfc)this.rotation, this.left);
    }
}

