/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.network;

import com.mafuyu404.diligentstalker.network.Packet;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientFuelPacket(int entityId, int fuel) implements Packet
{
    public static final CustomPacketPayload.Type<ClientFuelPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"client_fuel"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientFuelPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ClientFuelPacket::entityId, (StreamCodec)ByteBufCodecs.VAR_INT, ClientFuelPacket::fuel, ClientFuelPacket::new);

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ? extends Packet> getStreamCodec() {
        return STREAM_CODEC;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ClientFuelPacket msg, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> ClientStalkerUtil.updateFuel(msg.entityId, msg.fuel));
        }
    }
}

