/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.network;

import com.mafuyu404.diligentstalker.network.Packet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EntityDataPacket(int entityId, CompoundTag nbt) implements Packet
{
    public static final CustomPacketPayload.Type<EntityDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"entity_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EntityDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, EntityDataPacket::entityId, (StreamCodec)StreamCodec.of((buf, nbt) -> buf.writeNbt((Tag)nbt), buf -> buf.readNbt()), EntityDataPacket::nbt, EntityDataPacket::new);

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ? extends Packet> getStreamCodec() {
        return STREAM_CODEC;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(EntityDataPacket msg, IPayloadContext ctx) {
        if (ctx.flow().isServerbound()) {
            ctx.enqueueWork(() -> {
                Player player = ctx.player();
                Level level = player.level();
                Entity entity = level.getEntity(msg.entityId);
                if (entity == null) {
                    return;
                }
                entity.getPersistentData().merge(msg.nbt);
                entity.getPersistentData().put("StalkerControlInput", msg.nbt.get("StalkerControlInput"));
            });
        }
    }
}

