/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.diligentstalker.network;

import com.mafuyu404.diligentstalker.network.Packet;
import com.mafuyu404.diligentstalker.utils.ServerStalkerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerRemoteConnectPacket(BlockPos blockPos) implements Packet
{
    public static final CustomPacketPayload.Type<ServerRemoteConnectPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diligentstalker", (String)"server_remote_connect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerRemoteConnectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ServerRemoteConnectPacket::blockPos, ServerRemoteConnectPacket::new);

    public ServerRemoteConnectPacket(BlockPos blockPos) {
        this.blockPos = blockPos == null ? BlockPos.ZERO : blockPos;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ? extends Packet> getStreamCodec() {
        return STREAM_CODEC;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ServerRemoteConnectPacket msg, IPayloadContext ctx) {
        if (ctx.flow().isServerbound()) {
            ctx.enqueueWork(() -> ServerStalkerUtil.setVisualCenter(ctx.player(), msg.blockPos));
        }
    }
}

